% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{note_ngram}
\alias{note_ngram}
\title{Note/chord n-gram}
\usage{
note_ngram(notes, n = 2, tally = FALSE, rests = FALSE)
}
\arguments{
\item{notes}{a noteworthy string.}

\item{n}{Number of grams. Must be >= 1 and <= number of timesteps in
\code{notes}.}

\item{tally}{logical, tally n-grams in a data frame. Otherwise a list.}

\item{rests}{logical, exclude rests. Affects the number of timesteps.}
}
\value{
list of noteworthy objects or a tibble
}
\description{
Convert a noteworthy string to a list of noteworthy n-grams.
}
\examples{
x <- as_noteworthy("c r ceg dfa ceg dfa")
note_ngram(x)
(x <- note_ngram(x, tally = TRUE))
x$ngram <- as.character(x$ngram)
x
}
