% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{notate}
\alias{notate}
\title{Add text to music staff}
\usage{
notate(x, text, position = "top")
}
\arguments{
\item{x}{character.}

\item{text}{character.}

\item{position}{character, top or bottom.}
}
\value{
a character string.
}
\description{
Annotate a music staff, vertically aligned above or below the music staff at a specific note/time.
}
\details{
This function binds text annotation in LilyPond syntax to a note's associated \code{info} entry.
Technically, the syntax is a hybrid form, but is later updated safely and unambiguously to LilyPond syntax with respect to the rest of the note info substring when it is fed to \code{phrase} for musical phrase assembly.
}
\examples{
notate("8", "Solo")
phrase("c'~ c' d' e'", glue(notate(8, "First solo"), "8 8 4."), "5 5 5 5")
}
