% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{merge.tableMatrix}
\alias{merge.tableMatrix}
\title{Merge}
\usage{
\method{merge}{tableMatrix}(x, y, key, ...)
}
\arguments{
\item{x}{\code{tableMatrix} object}

\item{y}{data.table or data.frame object.}

\item{key}{Shared columns as merging key.}

\item{...}{Passed arguments.}
}
\value{
\code{tableMatrix} object.
}
\description{
\code{tableMatrix} method, merges \code{tableMatrix} objects with data.table or 
data.frame.
}
\examples{

data(images8By8)

# Create tableMatrix from images8By8
TM <- tableMatrix(images8By8, c("direction","dimX","dimY"), 4:ncol(images8By8), c(8,8))

# Merge tableMatrix object with a data.frame
merge(TM, data.frame(direction="down", flag=TRUE), key="direction")

}

