% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_spec.R
\name{format_decimal}
\alias{format_decimal}
\title{Format decimal symbol}
\usage{
format_decimal(rspec, mark = ".")
}
\arguments{
\item{rspec}{a \code{rounding_specification} object (see \link{round_spec}).}

\item{mark}{a character value used to represent the decimal point.}
}
\value{
an object of class \code{rounding_specification}.
}
\description{
\code{format_decimal()} lets you update the settings of a
\code{rounding_specification} object (see \link{round_spec}) so that
the decimal is represented by a user-specified mark.
}
\examples{

small_x <- 0.1234567

rspec <- round_spec()
rspec <- round_using_decimal(rspec, digits = 7)
rspec <- format_decimal(rspec, mark = '*')

table_value(small_x, rspec)

}
\seealso{
Other formatting helpers: 
\code{\link{format_small}()}
}
\concept{formatting helpers}
