% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoji.R
\name{str_split_emoji}
\alias{str_split_emoji}
\title{Split a string into emoji and non-emoji glyph runs}
\usage{
str_split_emoji(
  string,
  family = "",
  italic = FALSE,
  bold = FALSE,
  path = NULL,
  index = 0
)
}
\arguments{
\item{string}{A character vector of strings that should be splitted.}

\item{family}{The name of the font family}

\item{italic}{logicals indicating the font style}

\item{bold}{logicals indicating the font style}

\item{path, index}{path an index of a font file to circumvent lookup based on
family and style}
}
\value{
A data.frame containing the following columns:
\describe{
\item{string}{The substring containing a consecutive run of glyphs}
\item{id}{The index into the original \code{string} vector that the substring is part of}
\item{emoji}{A logical vector giving if the substring is a run of emojis or not}
}
}
\description{
In order to do correct text rendering, the font needed must be figured out. A
common case is rendering of emojis within a string where the system emoji
font is used rather than the requested font. This function will inspect the
provided strings and split them up in runs that must be rendered with the
emoji font, and the rest. Arguments are recycled to the length of the \code{string}
vector.
}
\examples{
emoji_string <- "This is a joke\U0001f642. It should be obvious from the smiley"
str_split_emoji(emoji_string)

}
