% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_SS.R
\name{data.gen.LGSS}
\alias{data.gen.LGSS}
\title{Linear Gaussian state-space model}
\usage{
data.gen.LGSS(
  theta,
  nobs,
  start = runif(n = 1, min = -1, max = 1),
  do.plot = TRUE
)
}
\arguments{
\item{theta}{The parameters \eqn{\theta=\{\phi,\sigma_v,\sigma_e\}} of the LGSS model.}

\item{nobs}{The data length to be generated.}

\item{start}{A numeric value indicating the starting value for the time series.
If the starting point is not specified, it is generated randomly.}

\item{do.plot}{Logical value. If TRUE (default value), a plot of the generated LGSS system is shown.}
}
\value{
A list of two variables, state and response.
}
\description{
Generates data from a specific linear Gaussian state space model of the form
\eqn{ x_{t} = \phi x_{t-1} + \sigma_v v_t } and \eqn{ y_t = x_t +
\sigma_e e_t }, where \eqn{v_t} and \eqn{e_t} denote independent standard
Gaussian random variables, i.e. \eqn{N(0,1)}.
}
\examples{
data.LGSS <- data.gen.LGSS(theta=c(0.75,1.00,0.10), nobs=500, start=0)
}
\references{
#Dahlin, J. & Schon, T. B. "Getting Started with Particle Metropolis-Hastings for Inference in Nonlinear Dynamical Models."
Journal of Statistical Software, Code Snippets, 88(2): 1--41, 2019.
}
