% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nc.R
\name{read_nc}
\alias{read_nc}
\title{Read a NetCDF file}
\usage{
read_nc(nc_input, name_coord, initial_date)
}
\arguments{
\item{nc_input}{NetCDF path with atmospheric or environmental field (mean sea level pressure, geopotential height, precipitation, ...).}

\item{name_coord}{Character. Names of longitude, latitude and time coordinates.}

\item{initial_date}{Character. Start date of the NetCDF. As character format.}
}
\value{
a list with: \itemize{
   \item{A 3D-array (lon, lat, times) of atmospheric variable.}
   \item{A numeric with longitude values.}
   \item{A numeric with latitude values.}
   \item{A Date format vector containing dates.}
}
}
\description{
This function read a NetCDF file through \pkg{ncdf4} package, to extract the atmospheric or environmental variable, longitudes, latitudes and dates. A continuous NetCDF withouth date gaps is required.
}
