% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwt_env_raststack.R
\name{cwt_env_raststack}
\alias{cwt_env_raststack}
\title{Raster conversion of environmental data based on CWT}
\usage{
cwt_env_raststack(longitude, latitude, grid_data, cluster_data,
  option = 1, na.rm = T)
}
\arguments{
\item{longitude}{Numeric vector containing longitudes}

\item{latitude}{Numeric vector containing latitudes}

\item{grid_data}{Data frame containing the environmental data (i.e. precipitation, temperature, PM10, etc.)}

\item{cluster_data}{Integer containing the results of the synoptic classification.}

\item{option}{Integer (1 or 2), to manage latitude and longitude data when convert to raster. Try 2 if 1 is wrong and viceversa. Default is 1.}

\item{na.rm}{Logical. If TRUE, all the grid points are used to calculate the daily mean although NA exists. If FALSE, only grid points with the complete serie are used to compute the daily mean. Default is TRUE.}
}
\value{
a Raster Stack containing the environmental grids based on the weather types.
}
\description{
This function convert the dataframe of the environmental data based on the synoptic classification into a raster stack format.
}
\examples{
# Load data (precp_grid)
data(precp_grid)
# Converting our data, but without modifying time period
smode_mslp <- tidy_cuttime_nc(mslp, only_convert = TRUE)
precp_data <- tidy_cuttime_nc(precp_grid, only_convert = TRUE)
# classification performance
smode_clas <- synoptclas(smode_mslp$smode_data, ncomp = 6)
# convert all the precipitation maps based on CWT to a raster stack
raster_precp <- cwt_env_raststack(longitude = precp_grid$lon,
                latitude = precp_grid$lat, grid_data = precp_data$smode_data,
                cluster_data = smode_clas$clas, option = 2)
}
