/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import java.util.Arrays;
import sample.DuoNodes;
import vcf.BasicGL;
import vcf.GL;

public class DuoBaumLevel {
    private static final int INITIAL_CAPACITY = 400;
    private static final double MIN_VALUE = 4.94E-322;
    private final Dag dag;
    private final GL gl;
    private int marker = -1;
    private int sampleA = -1;
    private int sampleB = -1;
    private int size = 0;
    private int capacity = 400;
    private int[] edgesAB1 = new int[400];
    private int[] edgesA2 = new int[400];
    private int[] edgesB2 = new int[400];
    private double[] fwdValues = new double[400];
    private double[] bwdValues = new double[400];
    private double fwdValueSum = 0.0;
    private double bwdValueSum = 0.0;
    private int nGenotypes = 0;
    private double[] gtProbsA = new double[3];
    private double[] gtProbsB = new double[3];

    public DuoBaumLevel(Dag dag, GL gL) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("marker inconsistency");
        }
        this.dag = dag;
        this.gl = gL;
    }

    public static void initializeNodes(DuoNodes duoNodes) {
        duoNodes.clear();
        duoNodes.sumUpdate(0, 0, 0, 1.0);
    }

    public void setForwardValues(DuoNodes duoNodes, int n, int n2, int n3) {
        this.marker = n;
        this.sampleA = n2;
        this.sampleB = n3;
        this.nGenotypes = this.gl.marker(n).nGenotypes();
        this.size = 0;
        this.fwdValueSum = 0.0;
        this.bwdValueSum = 0.0;
        this.initializeGtProbs();
        this.setStates(duoNodes);
        this.setChildNodes(duoNodes);
    }

    private void initializeGtProbs() {
        if (this.gtProbsA.length < this.nGenotypes) {
            int n = Math.max(this.nGenotypes, 3 * this.gtProbsA.length / 2 + 1);
            this.gtProbsA = new double[n];
            this.gtProbsB = new double[n];
        } else {
            for (int i = 0; i < this.nGenotypes; ++i) {
                this.gtProbsA[i] = 0.0;
                this.gtProbsB[i] = 0.0;
            }
        }
    }

    private void setStates(DuoNodes duoNodes) {
        int n;
        double d = 0.0;
        int n2 = duoNodes.size();
        for (n = 0; n < n2; ++n) {
            int n3 = duoNodes.enumNodeAB1(n);
            int n4 = duoNodes.enumNodeA2(n);
            int n5 = duoNodes.enumNodeB2(n);
            double d2 = duoNodes.enumValue(n);
            int n6 = this.dag.nOutEdges(this.marker, n3);
            for (int i = 0; i < n6; ++i) {
                int n7 = this.dag.outEdge(this.marker, n3, i);
                byte by = this.dag.symbol(this.marker, n7);
                int n8 = this.dag.nOutEdges(this.marker, n4);
                for (int j = 0; j < n8; ++j) {
                    int n9 = this.dag.outEdge(this.marker, n4, j);
                    byte by2 = this.dag.symbol(this.marker, n9);
                    float f = this.gl.gl(this.marker, this.sampleA, by, by2);
                    if (!((double)f > 0.0)) continue;
                    int n10 = this.dag.nOutEdges(this.marker, n5);
                    for (int k = 0; k < n10; ++k) {
                        double d3;
                        double d4;
                        double d5;
                        double d6;
                        int n11 = this.dag.outEdge(this.marker, n5, k);
                        byte by3 = this.dag.symbol(this.marker, n11);
                        float f2 = this.gl.gl(this.marker, this.sampleB, by, by3);
                        if (!((double)f2 > 0.0)) continue;
                        if (this.size == this.capacity) {
                            this.ensureCapacity(this.size + 1);
                        }
                        if ((d6 = (double)(f * f2) * d2 * ((d5 = (double)this.dag.condEdgeProb(this.marker, n7)) * (d4 = (double)this.dag.condEdgeProb(this.marker, n9)) * (d3 = (double)this.dag.condEdgeProb(this.marker, n11)))) < 4.94E-322 && d2 > 0.0) {
                            d6 = 4.94E-322;
                        }
                        this.edgesAB1[this.size] = n7;
                        this.edgesA2[this.size] = n9;
                        this.edgesB2[this.size] = n11;
                        this.fwdValues[this.size++] = d6;
                        d += d6;
                    }
                }
            }
        }
        assert (d > 0.0 ^ this.size == 0);
        n = 0;
        while (n < this.size) {
            int n12 = n++;
            this.fwdValues[n12] = this.fwdValues[n12] / d;
        }
        this.fwdValueSum = d;
    }

    public void setChildNodes(DuoNodes duoNodes) {
        duoNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edgesAB1[i]);
            int n2 = this.dag.childNode(this.marker, this.edgesA2[i]);
            int n3 = this.dag.childNode(this.marker, this.edgesB2[i]);
            duoNodes.sumUpdate(n, n2, n3, this.fwdValues[i]);
        }
    }

    public void setInitialBackwardValues(DuoNodes duoNodes) {
        duoNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edgesAB1[i]);
            int n2 = this.dag.childNode(this.marker, this.edgesA2[i]);
            int n3 = this.dag.childNode(this.marker, this.edgesB2[i]);
            duoNodes.maxUpdate(n, n2, n3, 1.0);
        }
        this.setBackwardValues(duoNodes);
    }

    public void setBackwardValues(DuoNodes duoNodes) {
        int n;
        this.bwdValueSum = 0.0;
        double d = 0.0;
        for (n = 0; n < this.size; ++n) {
            double d2;
            int by3 = this.dag.childNode(this.marker, this.edgesAB1[n]);
            int n2 = this.dag.childNode(this.marker, this.edgesA2[n]);
            int n3 = this.dag.childNode(this.marker, this.edgesB2[n]);
            this.bwdValues[n] = d2 = duoNodes.value(by3, n2, n3);
            this.bwdValueSum += d2;
        }
        duoNodes.clear();
        for (n = 0; n < this.size; ++n) {
            double d3;
            int n4 = n;
            this.bwdValues[n4] = this.bwdValues[n4] / this.bwdValueSum;
            byte by = this.symbolAB1(n);
            byte by2 = this.symbolA2(n);
            byte by3 = this.symbolB2(n);
            int n5 = this.dag.parentNode(this.marker, this.edgesAB1[n]);
            int n6 = this.dag.parentNode(this.marker, this.edgesA2[n]);
            int n7 = this.dag.parentNode(this.marker, this.edgesB2[n]);
            double d4 = this.dag.condEdgeProb(this.marker, this.edgesAB1[n]);
            double d5 = this.dag.condEdgeProb(this.marker, this.edgesA2[n]);
            double d6 = this.dag.condEdgeProb(this.marker, this.edgesB2[n]);
            double d7 = this.fwdValues[n] * this.bwdValues[n];
            int n8 = BasicGL.genotype(by, by2);
            int n9 = BasicGL.genotype(by, by3);
            int n10 = n8;
            this.gtProbsA[n10] = this.gtProbsA[n10] + d7;
            int n11 = n9;
            this.gtProbsB[n11] = this.gtProbsB[n11] + d7;
            d += d7;
            double d8 = this.gl.gl(this.marker, this.sampleA, by, by2);
            double d9 = this.bwdValues[n] * (d4 * d5 * d6) * (d8 * (d3 = (double)this.gl.gl(this.marker, this.sampleB, by, by3)));
            if (d9 < 4.94E-322 && this.bwdValues[n] > 0.0) {
                d9 = 4.94E-322;
            }
            duoNodes.sumUpdate(n5, n6, n7, d9);
        }
        n = 0;
        while (n < this.nGenotypes) {
            int n12 = n;
            this.gtProbsA[n12] = this.gtProbsA[n12] / d;
            int n13 = n++;
            this.gtProbsB[n13] = this.gtProbsB[n13] / d;
        }
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public int marker() {
        return this.marker;
    }

    public int nGenotypes() {
        return this.nGenotypes;
    }

    public double gtProbsA(int n) {
        this.checkGT(n);
        return this.gtProbsA[n];
    }

    public double gtProbsB(int n) {
        this.checkGT(n);
        return this.gtProbsB[n];
    }

    private void checkGT(int n) {
        if (n >= this.nGenotypes) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    public int size() {
        return this.size;
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(this.size));
        }
    }

    public int edgeAB1(int n) {
        this.checkIndex(n);
        return this.edgesAB1[n];
    }

    public int edgeA2(int n) {
        this.checkIndex(n);
        return this.edgesA2[n];
    }

    public int edgeB2(int n) {
        this.checkIndex(n);
        return this.edgesB2[n];
    }

    public int parentNodeAB1(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesAB1[n]);
    }

    public int parentNodeA2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesA2[n]);
    }

    public int parentNodeB2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesB2[n]);
    }

    public int childNodeAB1(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesAB1[n]);
    }

    public int childNodeA2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesA2[n]);
    }

    public int childNodeB2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesB2[n]);
    }

    public byte symbolAB1(int n) {
        return this.dag.symbol(this.marker, this.edgeAB1(n));
    }

    public byte symbolA2(int n) {
        return this.dag.symbol(this.marker, this.edgeA2(n));
    }

    public byte symbolB2(int n) {
        return this.dag.symbol(this.marker, this.edgeB2(n));
    }

    public double forwardValue(int n) {
        this.checkIndex(n);
        return this.fwdValues[n];
    }

    public double backwardValue(int n) {
        this.checkIndex(n);
        return this.bwdValues[n];
    }

    public double forwardValuesSum() {
        return this.fwdValueSum;
    }

    public double backwardValuesSum() {
        return this.bwdValueSum;
    }

    public String toString() {
        String string = " ";
        String string2 = " | ";
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("level=");
        stringBuilder.append(this.marker);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" forwardValuesSum=");
        stringBuilder.append(this.fwdValueSum);
        stringBuilder.append(" backwardSum=");
        stringBuilder.append(this.bwdValueSum);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("j=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.edgeAB1(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edgeA2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edgeB2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.forwardValue(i));
            stringBuilder.append(string);
            stringBuilder.append(this.backwardValue(i));
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
            if (this.capacity < n) {
                this.capacity = n;
            }
            this.edgesAB1 = Arrays.copyOf(this.edgesAB1, this.capacity);
            this.edgesA2 = Arrays.copyOf(this.edgesA2, this.capacity);
            this.edgesB2 = Arrays.copyOf(this.edgesB2, this.capacity);
            this.fwdValues = Arrays.copyOf(this.fwdValues, this.capacity);
            this.bwdValues = Arrays.copyOf(this.bwdValues, this.capacity);
        }
    }
}

