/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import java.util.Arrays;

public class IndexMap {
    private final int nil;
    private final int[] values;
    private final int[] keys;
    private int size = 0;

    public IndexMap(int n) {
        this(n, Integer.MIN_VALUE);
    }

    public IndexMap(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("maxKey<0: " + n);
        }
        this.nil = n2;
        this.values = new int[n + 1];
        this.keys = new int[n + 1];
        Arrays.fill(this.values, n2);
    }

    public int nil() {
        return this.nil;
    }

    public int put(int n, int n2) {
        if (n2 == this.nil) {
            throw new IllegalArgumentException("value==nil()");
        }
        int n3 = this.values[n];
        if (n3 == this.nil) {
            this.keys[this.size++] = n;
        }
        this.values[n] = n2;
        return n3;
    }

    public int get(int n) {
        return this.values[n];
    }

    public int size() {
        return this.size;
    }

    public int maxKey() {
        return this.keys.length - 1;
    }

    public void clear() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.values[this.keys[i]] = this.nil;
        }
        this.size = 0;
    }

    public int enumKey(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.keys[n];
    }

    public int enumValue(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.values[this.keys[n]];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" {");
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.enumKey(i));
            stringBuilder.append(" : ");
            stringBuilder.append(this.enumValue(i));
            if (i + 1 >= this.size) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

