/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public final class RevGL
implements GL {
    private final int lastMarker;
    private final GL gl;

    public RevGL(GL gL) {
        this.lastMarker = gL.nMarkers() - 1;
        this.gl = gL;
    }

    @Override
    public boolean isRefData() {
        return this.gl.isRefData();
    }

    @Override
    public float gl(int n, int n2, byte by, byte by2) {
        int n3 = this.lastMarker - n;
        return this.gl.gl(n3, n2, by, by2);
    }

    @Override
    public byte allele1(int n, int n2) {
        int n3 = this.lastMarker - n;
        return this.gl.allele1(n3, n2);
    }

    @Override
    public byte allele2(int n, int n2) {
        int n3 = this.lastMarker - n;
        return this.gl.allele2(n3, n2);
    }

    @Override
    public Marker marker(int n) {
        int n2 = this.lastMarker - n;
        return this.gl.marker(n2);
    }

    @Override
    public Markers markers() {
        return this.gl.markers().reverse();
    }

    @Override
    public int nMarkers() {
        return this.gl.nMarkers();
    }

    @Override
    public int nSamples() {
        return this.gl.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gl.samples();
    }

    @Override
    public String toString() {
        return this.gl.toString();
    }
}

