% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/allGenerics.R, R/lazyRepo.R
\docType{methods}
\name{lazyRepo}
\alias{lazyRepo}
\alias{lazyRepo,SessionManifest,ANY}
\alias{lazyRepo,SessionManifest,ANY-method}
\alias{lazyRepo,character,PkgManifest}
\alias{lazyRepo,character,PkgManifest-method}
\alias{lazyRepo,character,SessionManifest}
\alias{lazyRepo,character,SessionManifest-method}
\title{lazyRepo}
\usage{
lazyRepo(pkgs, pkg_manifest, versions = rep(NA, times = length(pkgs)),
  dir = tempdir(), rep_path = file.path(dir, "repo"),
  get_suggests = FALSE, verbose = FALSE, scm_auths = list(bioconductor =
  c("readonly", "readonly")), param = SwitchrParam(), force_refresh = FALSE)

\S4method{lazyRepo}{SessionManifest,ANY}(pkgs, pkg_manifest,
  versions = rep(NA, times = length(pkgs)), dir = tempdir(),
  rep_path = file.path(dir, "repo"), get_suggests = FALSE,
  verbose = FALSE, scm_auths = list(bioconductor = c("readonly",
  "readonly")), param = SwitchrParam(), force_refresh = FALSE)

\S4method{lazyRepo}{character,SessionManifest}(pkgs, pkg_manifest,
  versions = rep(NA, times = length(pkgs)), dir = tempdir(),
  rep_path = file.path(dir, "repo"), get_suggests = FALSE,
  verbose = FALSE, scm_auths = list(bioconductor = c("readonly",
  "readonly")), param = SwitchrParam(), force_refresh = FALSE)

\S4method{lazyRepo}{character,PkgManifest}(pkgs, pkg_manifest,
  versions = rep(NA, times = length(pkgs)), dir = tempdir(),
  rep_path = file.path(dir, "repo"), get_suggests = FALSE,
  verbose = FALSE, scm_auths = list(bioconductor = c("readonly",
  "readonly")), param = SwitchrParam(), force_refresh = FALSE)
}
\arguments{
\item{pkgs}{The packages to install}

\item{pkg_manifest}{The manifest to use}

\item{versions}{Specific versions of the packages to install. Should be a
vector of the same length as \code{pkgs} (and in the same order). Defaults
to NA (any version) for all packages.}

\item{dir}{The directory packages should be downloaded/checkedout/built into}

\item{rep_path}{The path of the final repository}

\item{get_suggests}{Whether suggested packages should be included
in the lazy repository. Defaults to FALSE}

\item{verbose}{Should extra information be printed to the user during
the construction process}

\item{scm_auths}{Named list of username/password credentials for checking
out package sources from one or more sources listed in \code{manifest}
Defaults to readonly access to Bioconductor SVN}

\item{param}{A SwitchrParam object}

\item{force_refresh}{If a package already appears in the lazy repo area,
it be updated (e.g. from SCM) and built again? Defaults to FALSE}
}
\value{
A path to the populated lazy repository, suitable for 'coercing' to
a url and installing from.
}
\description{
Create a lazy repository for installing directly from a package
manifest. Most users will want to call \code{Install} directly,
which will call this as needed behind the scenes.
}
\author{
Gabriel Becker
}

