% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crandbtmp.R
\name{cranPkgVersManifest}
\alias{cranPkgVersManifest}
\title{cranPkgVersManifest
Create a Pkg manifest which points to tarballs representing a particular
version of a CRAN package and versions of its (recursive) dependencies
that were contemporary on the first or last day the specified package
version resided on CRAN}
\usage{
cranPkgVersManifest(pkg, vers, earliest = TRUE,
  cur_avail = available.packages(), verbose = FALSE,
  suggests = c("direct", "none"), delay = 1)
}
\arguments{
\item{pkg}{The package on which to base the generated manifest}

\item{vers}{The version of \code{pkg} to construct the cohort around. Note
this must match the the version string exactly, i.e. 1.3.1 and 1.3-1 are
*not* equivalent.}

\item{earliest}{Should the package dependencies be contemporary with the
first (TRUE) or last (FALSE) day the specified package version was
(the latest version) on CRAN?}

\item{cur_avail}{The output from available.packages(). Used to identify
whether the necessary version is in the CRAN archive or normal repository}

\item{verbose}{Should debugging information about the recursive traversal of
package dependencies be printed (defaults to FALSE).}

\item{suggests}{Which Suggests'ed packages should be included. Currently
supported possibilites are direct, indicating Suggestions of \code{pkg}
should be included, and none, indicating that no Suggests'ed packages
should be counted.}

\item{delay}{Number of seconds to delay between successive REST calls
to the crandb database. Defaults to 1 second}
}
\value{
A SessionManifest object
}
\description{
cranPkgVersManifest
Create a Pkg manifest which points to tarballs representing a particular
version of a CRAN package and versions of its (recursive) dependencies
that were contemporary on the first or last day the specified package
version resided on CRAN
}
\note{
Some packages retain the same version on CRAN for long periods of
time. The cohort in the manifest represents a gross proxy for the cohort
used in conjunction within an analysis which used a the \code{vers} version
of the specified package. In general it will *not* perfectly recreate
the set of package versions originally used.
}
\examples{
\dontrun{
man = cranPkgVersManifest("devtools", "1.6")
}
}
\author{
Gabriel Becker
}
\references{
"Gabor Csardi" (2014). crandb: Query the unofficial CRAN metadata
 database. R package version 1.0.0. https://github.com/metacran/crandb
}

