% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caption.R
\name{caption}
\alias{caption}
\title{A caption widget}
\arguments{
\item{eavesdrop}{Two strings of the caption widget as c("Title", "subTitle").}

\item{size}{A number used to designate the size (magnification) of the
widget. The default is set to \code{1} which is 80 by 80 pixels. For
example, setting to \code{3} will results in a widget 3-times the default
size (240 by 240 pixels) and will occupy a grid area of 3 by 3.}

\item{placeOnGrid}{A row by column coordinate (e.g., \code{c(row-number, column-number)})
of a grid that designates the position to draw the widget on the
\code{switchboard}. Use \code{showGrid()} to help organize widget placement
on dashboard. The default places the first widget in pipe chain to
the \code{c(1, 1)} position, and all following on the same row stacked to
the right.}

\item{extendRow}{An integer describing the number of columns a row should 
extend through. Extends the width of the widget but not it's height. Used to  
better organize text along a row within \code{caption} widget. For example,
when \code{size = 1} and \code{extendRow = 2} the caption widget will extend
to two columns rather than one, but still have a height of one.}
}
\value{
Nothing.
}
\description{
The \code{caption} widget displays a small title caption and smaller subtitle
caption.
}
\section{Usage}{

   \preformatted{caption(c("", ""), size = 1, placeOnGrid = c(1,1))}
}

\examples{
\dontrun{

   for(i in 1:250) {
     switchboard(delay = 0.01) \%>\%
       caption(c("A Title", "A small sub title"))
   }
   switchboard_close()

}

}
\concept{caption widgets}
