% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mnprobit}
\alias{predict.mnprobit}
\title{Predict method for mnprobit function}
\usage{
\method{predict}{mnprobit}(
  object,
  ...,
  newdata = NULL,
  alt = 1,
  regime = -1,
  type = ifelse(is.null(regime) | (regime == -1), "prob", "val"),
  alt_obs = "all",
  me = NULL,
  eps = NULL,
  control = list(),
  se = FALSE
)
}
\arguments{
\item{object}{object of class "mnprobit"}

\item{...}{further arguments (currently ignored)}

\item{newdata}{an optional data frame in which to look for variables 
with which to predict. If omitted, the original data frame used.
This data frame should contain values of dependent variables even if
they are not actually needed for prediction 
(simply assign them with 0 values).}

\item{alt}{index of the alternative. See 'Details' for more information.}

\item{regime}{regime of the continuous equation. 
See 'Details' for more information.}

\item{type}{string representing a type of prediction. See 'Details' for
more information.}

\item{alt_obs}{if \code{alt_obs = "all"} then all observations will
be used for prediction. If \code{alt_obs} equals to the index of the
alternative then only observations associated with this alternative
will be used.}

\item{me}{string representing the name of the variable for which marginal
effect should be estimated. See 'Details' for more information.}

\item{eps}{numeric vector of length 1 or 2 used for calculation of
marginal effects. See 'Details'.}

\item{control}{list of additional arguments. Currently is not intended
for the users.}

\item{se}{logical; if \code{TRUE} then the function also returns standard 
errors and p-values of the two-sided significance test associated with the 
function output. 
Works only if \code{\link[switchSelection]{predict.mvoprobit}} returns
numeric vector or a single column matrix. 
See \code{\link[switchSelection]{delta_method}} for more information.}
}
\value{
This function returns predictions for each row of \code{newdata}
or for each observation in the model if \code{newdata} is \code{NULL}.
Structure of the output depends on the \code{type} argument
(see 'Details' section).
}
\description{
Predict method for mnprobit function
}
\details{
See 'Examples' section of \code{\link[switchSelection]{mnprobit}}
for examples of this function application.

If \code{type = "prob"} then function returns a probability that
alternative \code{alt} will be chosen. For example if \code{alt = 2} then
probabilities \eqn{P(z_{i} = 2|w_{i})} will be estimated.
If \code{n_alt} is null then the function returns a matrix such that 
\code{i}-th column contains probability of selecting \code{i}-th alternative.

If \code{type = "li"} then function returns a matrix which columns are
linear indexes of corresponding equations.

If \code{type = "val"} then function returns predictions of conditional 
(on \code{group}) expectation of dependent variable in continuous equation
with regimes determined by \code{regime} argument. To predict unconditional 
expectations just set \code{alt = NULL}.

If \code{type = "lambda"} then function returns conditional 
(on \code{alt}) expectation of random error of continuous equation
in regime \code{regime}.

If \code{me} is provided then the function returns marginal effect
of variable \code{me} respect to the statistic determined by \code{type}
argument. 
For example if \code{me = "x1"} and \code{type = "prob"} then function 
returns a marginal effect of \code{x1} on the corresponding probability 
i.e. one that would be estimated if \code{me} is \code{NULL}.

If \code{length(eps) = 1} then \code{eps} is an increment in 
numeric differentiation procedure. 
If \code{eps} is \code{NULL} then this increment will be selected 
automatically taking into account scaling of variables. 
If \code{length(eps) = 2} then marginal effects will be estimated as the
difference between predicted value when variable \code{me} equals 
\code{eps[2]} and when it equals \code{eps[1]} correspondingly.
}
