% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airdas_comments.R
\name{airdas_comments}
\alias{airdas_comments}
\alias{airdas_comments.data.frame}
\alias{airdas_comments.airdas_df}
\alias{airdas_comments.airdas_dfr}
\title{Extract comments from AirDAS data}
\usage{
airdas_comments(x)

\method{airdas_comments}{data.frame}(x)

\method{airdas_comments}{airdas_df}(x)

\method{airdas_comments}{airdas_dfr}(x)
}
\arguments{
\item{x}{\code{airdas_dfr} or \code{airdas_df} object, 
or a data frame that can be coerced to a \code{airdas_dfr} object}
}
\value{
\code{x}, filtered for C events and with the added column
  comment_str containing the concatenated comment strings
}
\description{
Extract comments from \code{airdas_dfr} or \code{airdas_df} object
}
\details{
This function recreates the comment strings by 
  pasting the Data# columns back together for the C events (comments)
  
  See the examples section for how to search for comments with the
  phrase "record" to determine what extra information (e.g. molas)
  was being recorded vs ignored.
}
\examples{
y <- system.file("airdas_sample.das", package = "swfscAirDAS")
y.read <- airdas_read(y, file.type = "turtle")

airdas_comments(y.read)

# Extract all comments containing "record"
y.comm <- airdas_comments(y.read)
y.comm[grepl("record", y.comm$comment_str, ignore.case = TRUE), ]

# Extract all comments containing "record", but not "recorder"
y.comm <- airdas_comments(y.read)
y.comm[grepl("record", y.comm$comment_str, ignore.case = TRUE) & 
         !grepl("recorder", y.comm$comment_str, ignore.case = TRUE), ]
         
# Join comments with processed data
dplyr::left_join(y.read, y.comm[, c("file_das", "line_num", "comment_str")],
                 by = c("file_das", "line_num"))

}
