% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nas.R
\name{nas}
\alias{nas}
\title{Calculate Normalized Association Score}
\usage{
nas(w, S_words, A_words, B_words, verbose = FALSE)
}
\arguments{
\item{w}{a numeric matrix of word embeddings (e.g. from \code{\link[rsparse:GloVe]{rsparse::GloVe()}})}

\item{S_words}{a character vector of the first set of target words. In an example of studying gender stereotype, it can include occupations such as programmer, engineer, scientists...}

\item{A_words}{a character vector of the first set of attribute words. In an example of studying gender stereotype, it can include words such as man, male, he, his.}

\item{B_words}{a character vector of the second set of attribute words. In an example of studying gender stereotype, it can include words such as woman, female, she, her.}

\item{verbose}{logical, whether to display information}
}
\value{
A list with class \code{"nas"} containing the following components:
\describe{
\item{\code{$P}}{a vector of normalized association score for every word in S}
\item{\code{$raw}}{a list of raw results used for calculating normalized association scores}
\item{\code{$S_words}}{the input S_words}
\item{\code{$A_words}}{the input A_words}
\item{\code{$B_words}}{the input B_words}
}
}
\description{
This functions quantifies the bias in a set of word embeddings by Caliskan et al (2017). In comparison to WEAT introduced in the same paper, this method is more suitable for continuous ground truth data. See Figure 1 and Figure 2 of the original paper. If possible, please use \code{\link[=query]{query()}} instead.
}
\references{
Caliskan, A., Bryson, J. J., & Narayanan, A. (2017). Semantics derived automatically from language corpora contain human-like biases. Science, 356(6334), 183-186. \doi{10.1126/science.aal4230}
}
\author{
Chung-hong Chan
}
