% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnsb.R
\name{rnsb}
\alias{rnsb}
\title{Relative Negative Sentiment Bias}
\usage{
rnsb(w, S_words, A_words, B_words, levels = 1, verbose = FALSE)
}
\arguments{
\item{w}{a numeric matrix of word embeddings (e.g. from rsparse::GloVe)}

\item{S_words}{a character vector of the first set of target words. In an example of studying gender stereotype, it can include occupations such as programmer, engineer, scientists...}

\item{A_words}{a character vector of the first set of attribute words. In an example of studying gender stereotype, it can include words such as man, male, he, his.}

\item{B_words}{a character vector of the second set of attribute words. In an example of studying gender stereotype, it can include words such as woman, female, she, her.}

\item{levels}{levels of entries in a hierarchical dictionary that will be applied (see quanteda::dfm_lookup)}

\item{verbose}{logical, whether to display information}
}
\value{
A list with class \code{"rnsb"} containing the following components:
\describe{
\item{\code{$classifer}}{ a logistic regression model with L2 regularization trained with LiblineaR}
\item{\code{$A_words}}{the input A_words}
\item{\code{$B_words}}{the input B_words}
\item{\code{$S_words}}{the input S_words}
\item{\code{$P}}{the predicted negative sentiment probabilities}
}
\code{\link{rnsb_es}} can be used to obtain the effect size of the test.
}
\description{
This function estimate the Relative Negative Sentiment Bias (RNSB) of word embeddings (Sweeney & Najafian, 2019).
}
\examples{
data(googlenews)
S1 <- c("janitor", "statistician", "midwife", "bailiff", "auctioneer",
"photographer", "geologist", "shoemaker", "athlete", "cashier", "dancer",
"housekeeper", "accountant", "physicist", "gardener", "dentist", "weaver",
"blacksmith", "psychologist", "supervisor", "mathematician", "surveyor",
"tailor", "designer", "economist", "mechanic", "laborer", "postmaster",
"broker", "chemist", "librarian", "attendant", "clerical", "musician",
"porter", "scientist", "carpenter", "sailor", "instructor", "sheriff",
"pilot", "inspector", "mason", "baker", "administrator", "architect",
"collector", "operator", "surgeon", "driver", "painter", "conductor",
"nurse", "cook", "engineer", "retired", "sales", "lawyer", "clergy",
"physician", "farmer", "clerk", "manager", "guard", "artist", "smith",
"official", "police", "doctor", "professor", "student", "judge",
"teacher", "author", "secretary", "soldier")
A1 <- c("he", "son", "his", "him", "father", "man", "boy", "himself",
"male", "brother", "sons", "fathers", "men", "boys", "males", "brothers",
"uncle", "uncles", "nephew", "nephews")
B1 <- c("she", "daughter", "hers", "her", "mother", "woman", "girl",
"herself", "female", "sister", "daughters", "mothers", "women", "girls",
"females", "sisters", "aunt", "aunts", "niece", "nieces")
garg_f1 <- rnsb(googlenews, S1, A1, B1)
plot_bias(garg_f1)
}
\references{
Sweeney, C., & Najafian, M. (2019, July). A transparent framework for evaluating unintended demographic bias in word embeddings. In Proceedings of the 57th Annual Meeting of the Association for Computational Linguistics (pp. 1662-1667).
}
\author{
Chung-hong Chan
}
