% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-cosine-signal.R
\name{fit_local_cosine}
\alias{fit_local_cosine}
\title{Estimate parameters of a local cosine signal}
\usage{
fit_local_cosine(b, lmin = 8, full_estimation = FALSE)
}
\arguments{
\item{b}{2D complex array from the 'swdft' function}

\item{lmin}{the smallest local-signal to search for}

\item{full_estimation}{optionally return all parameter
estimates for every grid position, defaults to false.}
}
\value{
A list with three components
\item{ls_params}{A named numeric vector with the 5 least squares parameter
estimates, mean squared error, mean squared error of the linear fit, mean squared
error of fitting the mean, and the change in mse between the two}
\item{fitted}{length N time-series with the fitted values corresponding to
our least squares fit }
\item{full_estimation}{if full_estimation is TRUE, then return all parameter estimates
corresponding to each grid position}
}
\description{
Estimate parameters of a local cosine signal
}
\examples{
# First generate a local periodic signal
N <- 15
window_size <- 2^3
A <- 1
Fr <- 4
f <- (Fr * window_size) / N
phase <- 1
S <- 10
L <- 10
x <- local_signal(N=N, A=A, Fr=Fr, phase=phase, S=S, L=L)

# Take the SWDFT and estimate parameters with fit_local_cosine
b <- swdft(x=x, n=window_size, normalize=(1/sqrt(window_size)))
bhat <- fit_local_cosine(b)

}
