% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\docType{package}
\name{svs-package}
\alias{svs-package}
\title{Tools for Semantic Vector Spaces}
\description{
This package offers various tools for semantic vector spaces. There are techniques for correspondence analysis (simple,
  multiple and discriminant), latent semantic analysis, probabilistic latent semantic analysis, non-negative matrix
  factorization, latent class analysis, EM clustering, logratio analysis and log-multiplicative (association)
  analysis. Furthermore, the package has specialized distance measures and plotting functions as well as
  some helper functions.
}
\section{Contents}{

This package contains the following raw data files (in the folder \emph{extdata}):
\itemize{
   \item{\code{\link{SndT_Fra.txt}} }{Seventeen Dutch source words and their French translations.}
   \item{\code{\link{SndT_Eng.txt}} }{Seventeen Dutch source words and their English translations.}
   \item{\code{\link{InvT_Fra.txt}} }{Seventeen Dutch target words and their French source words.}
   \item{\code{\link{InvT_Eng.txt}} }{Seventeen Dutch target words and their English source words.}
   \item{\code{\link{Ctxt_Dut.txt}} }{Context words for seventeen Dutch words.}
   \item{\code{\link{Ctxt_Fra.txt}} }{Context words for seventeen Dutch words translated from French.}
   \item{\code{\link{Ctxt_Eng.txt}} }{Context words for seventeen Dutch words translated from English.}
}
The (fast procedures for the) techniques in this package are:
\itemize{
  \item{\code{\link{fast_sca}} }{Simple correspondence analysis.}
  \item{\code{\link{fast_mca}} }{Multiple correspondence analysis.}
  \item{\code{\link{fast_dca}} }{Discriminant correspondence analysis.}
  \item{\code{\link{fast_lsa}} }{Latent semantic analysis.}
  \item{\code{\link{fast_psa}} }{Probabilistic latent semantic analysis.}
  \item{\code{\link{fast_nmf}} }{Non-negative matrix factorization.}
  \item{\code{\link{fast_lca}} }{Latent class analysis.}
  \item{\code{\link{fast_E_M}} }{EM clustering.}
  \item{\code{\link{fast_lra}} }{Logratio analysis.}
  \item{\code{\link{fast_lma}} }{Log-multiplicative (association) analysis.}
}

The complete overview of local and global weighting functions in this package can be found on \code{\link{weighting_functions}}.

The specialized distance measures are:
\itemize{
  \item{\code{\link{dist_chisquare}} }{Chi-square distance.}
  \item{\code{\link{dist_cosine}} }{Cosine distance.}
  \item{\code{\link{dist_wrt}} }{Distance with respect to a certain point.}
  \item{\code{\link{dist_wrt_centers}} }{Distance with respect to cluster centers.}
}

The specialized plotting functions are:
\itemize{
  \item{\code{\link{cd_plot}} }{Cumulative distribution plot.}
  \item{\code{\link{pc_plot}} }{Parallel coordinate plot.}
}

There are two helper functions for correspondence analysis:
\itemize{
  \item{\code{\link{freq_ca}} }{Compute level frequencies (for a factor).}
  \item{\code{\link{centers_ca}} }{Compute coordinates for cluster centers.}
}

There is one helper function for \pkg{pvclust}:
\itemize{
  \item{\code{\link{complete_pvpick}} }{Complete the output of \code{pvpick}.}
}

The remaining helper functions in this package are:
\itemize{
  \item{\code{\link{vec2ind}} }{Transform a vector into an indicator matrix.}
  \item{\code{\link{tab2dat}} }{Transform a table into a data frame.}
  \item{\code{\link{tab2ind}} }{Transform a table into an indicator matrix.}
  \item{\code{\link{outerec}} }{Recursive application of the outer product.}
  \item{\code{\link{pmi}} }{Pointwise mutual information.}
  \item{\code{\link{MI}} }{Mutual information.}
  \item{\code{\link{log_or_0}} }{Logarithmic transform.}
}
}

\section{Further reference}{

\itemize{
  \item{Many packages contain correspondence analysis: \pkg{ca}, \pkg{FactoMineR}, \pkg{MASS} and others.}
  \item{For latent semantic analysis there is also the package \pkg{lsa}.}
  \item{The package \pkg{NMF} provides more flexibility for non-negative matrix factorization.}
  \item{For topic models there are the packages \pkg{lda} and \pkg{topicmodels}.}
  \item{Latent class analysis can also be run in the package \pkg{poLCA}.}
}
}

\section{Author}{

Koen Plevoets, \email{koen.plevoets@ugent.be}
}

\section{Acknowledgements}{

This package has benefited greatly from the helpful comments of Lore Vandevoorde, Pauline De Baets and Gert De Sutter. Thanks to
  Kurt Hornik, Uwe Ligges and Brian Ripley for their valuable recommendations when proofing this package.
}

