% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pmi}
\alias{PMI}
\alias{pmi}
\title{Pointwise Mutual Information}
\usage{
pmi(x, normalize = FALSE, base = 2)

PMI(x, normalize = FALSE, base = 2)
}
\arguments{
\item{x}{A table (i.e. an object which can be converted to an array).}

\item{normalize}{Logical indicating whether to normalize the pointwise mutual information.}

\item{base}{Numeric specification of the base with respect to which logarithms are computed.}
}
\value{
An array with the pointwise mutual information of every entry.
}
\description{
A function for computing the pointwise mutual information of every entry in a table.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\\t", quote = "\\"", encoding = "UTF-8")
tab.SndT_Fra <- table(SndT_Fra)
pmi(tab.SndT_Fra)
}
\seealso{
\code{\link{MI}}.
}

