% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratic_forms.R
\name{make_deville_tille_matrix}
\alias{make_deville_tille_matrix}
\title{Create a quadratic form's matrix
for a Deville-Tillé variance estimator for balanced samples}
\usage{
make_deville_tille_matrix(probs, aux_vars)
}
\arguments{
\item{probs}{A vector of first-order inclusion probabilities}

\item{aux_vars}{A matrix of auxiliary variables,
with the number of rows matching the number of elements of \code{probs}.}
}
\value{
A symmetric matrix whose dimension matches the length of \code{probs}.
}
\description{
Creates the quadratic form matrix for a
variance estimator for balanced samples,
proposed by Deville and Tillé (2005).
}
\details{
See Section 6.8 of Tillé (2020) for more detail on this estimator,
including an explanation of its quadratic form.
See Deville and Tillé (2005) for the results of a simulation study
comparing this and other alternative estimators for balanced sampling.

The estimator can be written as follows:
\deqn{
  v(\hat{Y})=\sum_{k \in S} \frac{c_k}{\pi_k^2}\left(y_k-\hat{y}_k^*\right)^2,
}
where
\deqn{
  \hat{y}_k^*=\mathbf{z}_k^{\top}\left(\sum_{\ell \in S} c_{\ell} \frac{\mathbf{z}_{\ell} \mathbf{z}_{\ell}^{\prime}}{\pi_{\ell}^2}\right)^{-1} \sum_{\ell \in S} c_{\ell} \frac{\mathbf{z}_{\ell} y_{\ell}}{\pi_{\ell}^2}
}
and \eqn{\mathbf{z}_k} denotes the vector of auxiliary variables for observation \eqn{k}
included in sample \eqn{S}, with inclusion probability \eqn{\pi_k}. The value \eqn{c_k} is set to \eqn{\frac{n}{n-q}(1-\pi_k)},
where \eqn{n} is the number of observations and \eqn{q} is the number of auxiliary variables.

See Li, Chen, and Krenzke (2014) for an example of this estimator's use
as the basis for a generalized replication estimator. See Breidt and Chauvet (2011)
for a discussion of alternative simulation-based estimators for the specific
application of variance estimation for balanced samples selected using the cube method.
}
\references{
- Breidt, F.J. and Chauvet, G. (2011).
"Improved variance estimation for balanced samples drawn via the cube method."
Journal of Statistical Planning and Inference, 141, 411-425.

- Deville, J.C., and Tillé, Y. (2005). "\emph{Variance approximation under balanced sampling.}"
\strong{Journal of Statistical Planning and Inference}, 128, 569-591.

- Li, J., Chen, S., and Krenzke, T. (2014).
"Replication Variance Estimation for Balanced Sampling: An Application to the PIAAC Study."
Proceedings of the Survey Research Methods Section, 2014: 985-994. Alexandria, VA: American Statistical Association.
http://www.asasrms.org/Proceedings/papers/1984_094.pdf.

- Tillé, Y. (2020). "\emph{Sampling and estimation from finite populations}." (I. Hekimi, Trans.). Wiley.
}
\keyword{internal}
