% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_replicates.R
\name{shuffle_replicates}
\alias{shuffle_replicates}
\title{Shuffle the order of replicates in a survey design object}
\usage{
shuffle_replicates(design)
}
\arguments{
\item{design}{A survey design object, created with either the \code{survey} or \code{srvyr} packages.}
}
\value{
An updated survey design object, where the order of the replicates
has been shuffled (i.e., the order has been randomly permuted).
}
\description{
Shuffle the order of replicates in a survey design object.
In other words, the order of the columns of replicate weights is randomly permuted.
}
\examples{
library(survey)
set.seed(2023)

# Create an example survey design object

  sample_data <- data.frame(
    STRATUM = c(1,1,1,1,2,2,2,2),
    PSU     = c(1,2,3,4,5,6,7,8)
  )

  survey_design <- svydesign(
    data = sample_data,
    strata = ~ STRATUM,
    ids = ~ PSU,
    weights = ~ 1
  )

  rep_design <- survey_design |>
    as_fays_gen_rep_design(variance_estimator = "Ultimate Cluster")

# Inspect replicates before shuffling

  rep_design |> getElement("repweights")

# Inspect replicates after shuffling

  rep_design |>
    shuffle_replicates() |>
    getElement("repweights")
}
