% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svinecop_methods.R
\name{svinecop_loglik}
\alias{svinecop_loglik}
\title{Log-likelihood for S-vine copula models}
\usage{
svinecop_loglik(u, model, cores = 1)
}
\arguments{
\item{u}{the data; should have approximately uniform margins.}

\item{model}{model inheriting from class \link{svinecop_dist}.}

\item{cores}{number of cores to use; if larger than one, computations are
done in parallel on \code{cores} batches .}
}
\value{
Returns the log-likelihood of the data for the model.
}
\description{
Log-likelihood for S-vine copula models
}
\examples{
# load data set
data(returns)  

# convert to uniform margins
u <- pseudo_obs(returns[1:100, 1:3])

# fit parametric S-vine copula model with Markov order 1
fit <- svinecop(u, p = 1, family_set = "parametric")

svinecop_loglik(u, fit)
svinecop_scores(u, fit)
svinecop_hessian(u, fit)
}
