% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdvis.R
\name{svd.parallel}
\alias{svd.parallel}
\title{Visualizing Singular Vectors or Principal Components by Parallel Coordinates Plots}
\usage{
svd.parallel(svd.obj, r = NULL, weights = NULL, group = NULL,
  alpha = 0.7, ...)
}
\arguments{
\item{svd.obj}{A list, resulted from applying svd to a dataset, with \code{u}, \code{d}, and \code{v} corresponding to left singular vector, singular values, and right singular vectors, respectively. Alternatively, supply singular vectors, \code{v}.}

\item{r}{A positive integer to use only the first \code{r} vectors in visualization. If not specified, all vectors available in \code{svd.obj$v} are visualized.}

\item{weights}{A vector of length \code{r}. If "sv", singular values contained in \code{svd.obj$d[1:r]} are used.}

\item{group}{A vector of length \code{n}, specifying groups (e.g., phenotypes or conditions for \code{n} samples).}

\item{alpha}{A numeric value for transparency.}

\item{...}{Additional arguments to pass onto \code{ggparcoord}.}
}
\value{
\code{svd.parallel} creates and draws a figure, which is a \code{ggplot} object.
}
\description{
Creates a Parallel Coordinates Plot from selected singular vectors or principal components.
Principal components can be plotted by setting \code{weights = "sv"}.
Since it largely uses \code{ggparcoord} from the \code{GGally} package, optional arguments for \code{ggparcoord} can be specified.
}
\examples{
set.seed(1234)
dat = matrix(rnorm(1000), 100, 10)
svd.obj = svd(dat)
colnames(svd.obj$v) = paste0("V",1:10)
rownames(svd.obj$v) = paste0("Sample",1:10)
svd.parallel(svd.obj, r=4)
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
\seealso{
\link{ggparcoord}
}

