% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chow.test.R
\name{chow.test}
\alias{chow.test}
\title{Chow Test for Structural Break}
\usage{
chow.test(Y, SB, p, nboot = 500, rademacher = "FALSE", start = NULL,
  end = NULL, frequency = NULL, format = NULL, dateVector = NULL)
}
\arguments{
\item{Y}{Data of multivariate time series in matrix form}

\item{SB}{Integer or date character. The structural break is specified either by an integer (number of observations in the pre-break period) or
a date character. If a date character is provided, either a date vector containing the whole time line
in the corresponding format or common time parameters need to be provided}

\item{p}{Integer. Number of lags included in the presumed VAR model}

\item{nboot}{Integer. Number of bootstrap iterations to calculate quantiles and p-values}

\item{rademacher}{If rademacher="TRUE", the Rademacher distribution is used to generate the bootstrap samples}

\item{start}{Character. Start of the time series (only if dateVector is empty)}

\item{end}{Character. End of the time series (only if dateVector is empty)}

\item{frequency}{Character. Frequency of the time series (only if dateVector is empty)}

\item{format}{Character. Date format (only if dateVector is empty)}

\item{dateVector}{Vector. Vector of time periods containing SB in corresponding format}
}
\value{
A list with elements
\item{lambda_bp}{Test statistic of the Chow test with break point}
\item{testcrit_bp}{Critical value of the test statistic lambda_bp}
\item{p.value_bp}{p-value of the test statistic lambda_bp}
\item{lambda_sp}{Test statistic of the Chow test with sample split}
\item{testcrit_sp}{Critival value of the test statistic lambda_sp}
\item{p.value_sp}{p-value of the test statistic lambda_sp}
}
\description{
The Chow test for structural change is implemented as sample-split and break-point test (see Luetkepohl and Kraetzig, 2004, p. 135). A multivariate time series and the presupposed structural break need to be provided.
}
\examples{
\donttest{
# Testing for structural break in USA data
z1 = chow.test(USA, SB = 65, p = 6)
summary(z1)

#Structural brake via Dates
#given that time series vector with dates is available
dateVector = seq(as.Date("1965/1/1"), as.Date("2008/6/1"), "quarter")
z2 <- chow.test(USA, SB = "1985-01-01", p = 6, format = "\%Y-\%m-\%d", dateVector = dateVector)
summary(z2)

# alternatively pass sequence arguments directly
z3 <- chow.test(USA, SB = "1985-01-01", p = 6, format = "\%Y-\%m-\%d",
                start = "1965-01-01", end = "2008-06-01",
                frequency = "quarter")

}
}
\references{
Luetkepohl, H., 2005. New introduction to multiple time series analysis, Springer-Verlag, Berlin.
     Luetkepohl, H., Kraetzig, M., 2004. Applied time series econometrics, Cambridge University Press, Cambridge.
}
