## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(survstan)
library(dplyr)

ovarian <- ovarian %>%
  mutate(
    rx = as.factor(rx)
  )

# fitting the model:
fit <- aftreg(Surv(futime, fustat) ~ rx + age, baseline = "weibull", data = ovarian, init = 0)

# investigating the fitted model:
estimates(fit)
coef(fit)
confint(fit)
summary(fit)
tidy(fit)
vcov(fit)


# residual plots:
ggresiduals(fit, type = "coxsnell")
ggresiduals(fit, type = "martingale")
ggresiduals(fit, type = "deviance")


# Deviance analysis:
fit1 <- aftreg(Surv(futime, fustat) ~ 1, baseline = "weibull", data = ovarian, init = 0)
fit2 <- aftreg(Surv(futime, fustat) ~ rx, baseline = "weibull", data = ovarian, init = 0)
fit3 <- aftreg(Surv(futime, fustat) ~ rx + ecog.ps, baseline = "weibull", data = ovarian, init = 0)

anova(fit1, fit2, fit3)

AIC(fit1, fit2, fit3)


