% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcumcensor.R
\name{ggcumcensor}
\alias{ggcumcensor}
\title{Cumulative Number of Censored Subjects}
\usage{
ggcumcensor(fit, data = NULL, color = "black", palette = NULL,
  break.time.by = NULL, xlim = NULL, title = "Number of cenored subjects",
  xlab = "Time", ylab = "Strata", legend = "top",
  legend.title = "Strata", legend.labs = NULL, y.text = TRUE,
  y.text.col = TRUE, fontsize = 4.5, ggtheme = theme_survminer(), ...)
}
\arguments{
\item{fit}{an object of class survfit.}

\item{data}{a dataset used to fit survival curves. If not supplied then data
will be extracted from 'fit' object.}

\item{color}{color to be used for the survival curves. This argument is
ignored when the number of strata (groups > 1). In this case, use the
argument palette.}

\item{palette}{the color palette to be used. Allowed values include "hue" for
the default hue color scale; "grey" for grey color palettes; brewer palettes
e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red").
See details section for more information.}

\item{break.time.by}{numeric value controlling time axis breaks. Default value is NULL.}

\item{xlim}{x and y axis limits e.g. xlim = c(0, 1000), ylim = c(0, 1).}

\item{title}{the title of the plot.}

\item{xlab}{main title and axis labels}

\item{ylab}{main title and axis labels}

\item{legend}{character specifying legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). Default is "top" side position.
to remove the legend use legend = "none". Legend position can be also
specified using a numeric vector c(x, y); see details section.}

\item{legend.title}{legend title.}

\item{legend.labs}{character vector specifying legend labels. Used to replace
the names of the strata from the fit. Should be given in the same order as
those strata.}

\item{y.text}{logical. Default is TRUE. If FALSE, the table y axis. tick
labels will be hidden.}

\item{y.text.col}{logical. Default value is FALSE. If TRUE, the table tick
labels will be colored by strata.}

\item{fontsize}{text font size.}

\item{ggtheme}{function, ggplot2 theme name. Default value is
\link{theme_survminer}. Allowed values include ggplot2 official themes: see
\code{\link[ggplot2]{theme}}.}

\item{...}{other arguments passed to the function \code{\link[ggpubr]{ggpar}}.}
}
\value{
a ggplot.
}
\description{
Plot the cumulative number of censored subjects, the number of subjects who
 exit the risk set, without an event, at time t. Normally, users don't need
 to use this function directly. Internally used by the function
 \code{\link{ggsurvplot}}.
}
\examples{
# Fit survival curves
require("survival")
fit<- survfit(Surv(time, status) ~ sex, data = lung)

# Basic plot
ggcumcensor(fit, data = lung)

# Change color by strata
# Remove y tick labels
ggcumcensor(fit, data = lung, color = "strata",
  y.text = FALSE)



}
\author{
Alboukadel Kassambara, \email{alboukadel.kassambara@gmail.com}
}
