% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.multidf.R
\name{plot.multidf}
\alias{plot.multidf}
\title{Plot methods for a multidf object}
\usage{
\method{plot}{multidf}(x, t1, method = "KMW", type = "s", ...)
}
\arguments{
\item{x}{An object of class multidf.}

\item{t1}{Value of the first gap time.}

\item{method}{A character string specifying which estimator to fit. Possible 
values are "KMW", "LIN", "WCH" and "LANDMARK".}

\item{type}{The type of plot that should be drawn. See details 
\code{\link{par}} for  possible options. 
Defaults to "s" for the draw be stair steps.}

\item{...}{Other options.}
}
\value{
No value is returned.
}
\description{
Provides the plots for the bivariate distribution function and
marginal distribution of the second time.
}
\examples{
data("bladder4state")

b3state<-multidf(gap1=bladder4state$y1, event1=bladder4state$d1, 
                 gap2=bladder4state$y2, status=bladder4state$d2, 
                 size=bladder4state$size)

head(b3state[[1]])

KMWdf(b3state,x=13,y=20)
LDMdf(b3state,x=13,y=20)
LINdf(b3state,x=13,y=20)
WCHdf(b3state,x=13,y=20)

plot(x=b3state, t1=3, method="KMW", type = "s")
plot(x=b3state, t1=3, method="LIN", type = "s")
plot(x=b3state, t1=3, method="WCH", type = "s")
plot(x=b3state, t1=3, method="LANDMARK", type = "s")

}
\references{
de Una-Alvarez, J. and Meira-Machado, L. (2008). A simple 
estimator of the bivariate distribution function for censored gap times, 
Statistics and Probability Letters 78, 2440-2445.
 
Davison, A.C. and Hinkley, D.V. (1997) "Bootstrap Methods and Their 
Application", Chapter 5. Cambridge University Press.
  
van Houwelingen, H.C. (2007). Dynamic prediction by landmarking in event 
history analysis, Scandinavian Journal of Statistics, 34, 70-85.
Kaplan, E. and Meier, P. (1958). Nonparametric Estimation from Incomplete 
Observations, Journal of the American Statistical Association 53(282), 
457-481.
}
\seealso{
\code{\link{KMWdf}}, \code{\link{LDMdf}}, \code{\link{LINdf}} and 
\code{\link{WCHdf}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
