% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survdnn.R
\name{survdnn}
\alias{survdnn}
\title{Fit a Deep Neural Network for Survival Analysis}
\usage{
survdnn(
  formula,
  data,
  hidden = c(32L, 16L),
  activation = "relu",
  lr = 1e-04,
  epochs = 300L,
  loss = c("cox", "cox_l2", "aft", "coxtime"),
  verbose = TRUE
)
}
\arguments{
\item{formula}{A survival formula of the form `Surv(time, status) ~ predictors`.}

\item{data}{A data frame containing the variables in the model.}

\item{hidden}{Integer vector. Sizes of the hidden layers (default: c(32, 16)).}

\item{activation}{Character string specifying the activation function to use in each layer.
Supported options: `"relu"`, `"leaky_relu"`, `"tanh"`, `"sigmoid"`, `"gelu"`, `"elu"`, `"softplus"`.}

\item{lr}{Learning rate for the Adam optimizer (default: `1e-4`).}

\item{epochs}{Number of training epochs (default: 300).}

\item{loss}{Character name of the loss function to use. One of `"cox"`, `"cox_l2"`, `"aft"`, or `"coxtime"`.}

\item{verbose}{Logical; whether to print loss progress every 50 epochs (default: TRUE).}
}
\value{
An object of class `"survdnn"` containing:
\describe{
  \item{model}{Trained `nn_module` object.}
  \item{formula}{Original survival formula.}
  \item{data}{Training data used for fitting.}
  \item{xnames}{Predictor variable names.}
  \item{x_center}{Column means of predictors.}
  \item{x_scale}{Column standard deviations of predictors.}
  \item{loss_history}{Vector of loss values per epoch.}
  \item{final_loss}{Final training loss.}
  \item{loss}{Loss function name used ("cox", "aft", etc.).}
  \item{activation}{Activation function used.}
  \item{hidden}{Hidden layer sizes.}
  \item{lr}{Learning rate.}
  \item{epochs}{Number of training epochs.}
}
}
\description{
Trains a deep neural network (DNN) to model right-censored survival data
using one of the predefined loss functions: Cox, AFT, or Coxtime.
}
\examples{
set.seed(123)
df <- data.frame(
  time = rexp(100, rate = 0.1),
  status = rbinom(100, 1, 0.7),
  x1 = rnorm(100),
  x2 = rbinom(100, 1, 0.5)
)
mod <- survdnn(Surv(time, status) ~ x1 + x2, data = df, epochs = 5

, loss = "cox", verbose = FALSE)
mod$final_loss
}
