% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_survcompare2.R
\name{survcompare2}
\alias{survcompare2}
\title{Compares two cross-validated models using surv____cv functions of this package.}
\usage{
survcompare2(base, alternative)
}
\arguments{
\item{base}{an object of type "survensemble_cv", for example, outcomes of survcox_cv, survsrf_cv, survsrfens_cv, survsrfstack_cv}

\item{alternative}{an object of type "survensemble_cv", to compare to "base"}
}
\value{
outcome = list(data frame with performance results, fitted Cox models, fitted DeespSurv)
}
\description{
#' The two arguments are two cross-validated models, base and alternative,
e.g., Cox Proportionate Hazards Model (or Cox LASSO), and Survival Random Forest,
or DeepHit (if installed from GitHub, not in CRAN version). Please see examples below.

Both cross-validations should be done with the same random seed, number of repetitions
(repeat_cv), outer_cv and inner_cv to ensure the models are compared on the same train/test splits.

Harrel's c-index,time-dependent AUC-ROC, time-dependent Brier Score, and calibration slopes are reported.
The statistical significance of the performance differences is tested for the C-indeces.

The function is designed to help with the model selection by quantifying the loss of predictive
performance (if any) if "alternative" is used instead of "base."
}
\examples{
df <-simulate_nonlinear(100)
params <- names(df)[1:4]
cv1 <- survcox_cv(df, params, randomseed = 42, repeat_cv =1)
cv2 <- survsrf_cv(df, params, randomseed = 42, repeat_cv = 1)
survcompare2(cv1, cv2)
}
