% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_10.r
\name{design.matrix}
\alias{design.matrix}
\title{Design matrix for the model needed in Gauss-Legendre quadrature}
\usage{
design.matrix(formula, data.spec, Z.smf, Z.tensor, Z.tint, list.smf,
  list.tensor, list.tint, list.rd)
}
\arguments{
\item{formula}{formula object identifying the model}

\item{data.spec}{data frame that represents the environment from which the covariate values and knots are to be calculated}

\item{Z.smf}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{smf}} splines}

\item{Z.tensor}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{tensor}} splines}

\item{Z.tint}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{tint}} splines}

\item{list.smf}{List of all smf.smooth.spec objects contained in the model}

\item{list.tensor}{List of all tensor.smooth.spec objects contained in the model}

\item{list.tint}{List of all tint.smooth.spec objects contained in the model}

\item{list.rd}{List of all rd.smooth.spec objects contained in the model}
}
\value{
design matrix for the model
}
\description{
Builds the design matrix for the whole model when the sum-to-zero constraints are specified. The function is called inside \code{\link{model.cons}}
for Gauss-Legendre quadrature.
}
