% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sf}
\alias{sf}
\title{Estimates of \bold{s}urvival (or hazard) \bold{f}unction
based on \eqn{n} and \eqn{e}}
\usage{
sf(n, e, what = c("all", "s", "sv", "h", "hv"))
}
\arguments{
\item{n}{\bold{N}umber at risk per time point (a \code{vector})}

\item{e}{Number of \bold{e}vents per time point (a \code{vector})}

\item{what}{See return, below}
}
\value{
The return value will be a \code{vector},
unless \code{what="all"} (the default),
in which case it will be a \code{data.table}.
\cr
If \code{what="s"}, the \bold{s}urvival is returned, based on the
Kaplan-Meier or product-limit estimator.
This is \eqn{1} at \eqn{t=0} and thereafter is given by:
\deqn{\hat{S}(t) = \prod_{t \leq t_i} (1-\frac{e_i}{n_i} )}{
      S = PROD 1-e/n}

If \code{what="sv"}, the \bold{s}urvival \bold{v}ariance is returned.
\cr
Greenwoods estimtor of the variance of the Kaplan-Meier (product-limit)
estimator is:
\deqn{Var[\hat{S}(t)] = [\hat{S}(t)]^2 \sum_{t_i \leq t} \frac{e_i}{n_i (n_i-e_i)} }{
      Var[S](t) = S(t)^2 SUM (e) / n(n-e) }

If \code{what="h"}, the \bold{h}azard is returned, based on the the Nelson-Aalen estimator.
This has a value of \eqn{\hat{H}=0}{H=0} at \eqn{t=0} and thereafter is given by:
\deqn{\hat{H}(t) = \sum_{t \leq t_i} \frac{e_i}{n_i}  }{
      H(t) = SUM e/n}

If \code{what="hv"}, the \bold{h}azard \bold{v}ariance is returned.
\cr
The variance of the Nelson-Aalen estimator is given by:
\deqn{Var[\hat{H}(t)] = \sum_{t_i \leq t} \frac{e_i}{n_i^2} }{
      SUM e/(n^2)}

If \code{what="all"} (the default), \emph{all} of the above are returned
in a \code{data.table}, along with:
\cr
Survival, based on the Nelson-Aalen estimator. Given by
             \deqn{\hat{S_{na}}=e^{H}}{
                   S = exp(H)}
          where \eqn{H} is hazard.
HKM Hazard, based on the Kaplan-Meier estimator. Given by
             \deqn{\hat{H_{km}}=-\log{S}}{
                   H = -log(S)}
where \eqn{S} is survival.
}
\description{
Estimates of \bold{s}urvival (or hazard) \bold{f}unction
based on \eqn{n} and \eqn{e}
}
\examples{
data(bmt, package="KMsurv")
b1 <- bmt[bmt$group==1, ] # ALL patients
t1 <- tne(Surv(time=b1$t2, event=b1$d3))
sf(n=t1$n, e=t1$e, what="all")
###
data(drug6mp, package="KMsurv")
s1 <- Surv(time=drug6mp$t2, event=drug6mp$relapse) # 6MP patients
t1 <- tne(s1)
sf(n=t1$n, e=t1$e, what="sv")
sf(n=t1$n, e=t1$e, what="hv")
}
\references{
Examples for are from:
\bold{K&M}.
\cr
\code{what="sv"}: Table 4.1A, pg 93.
\cr
\code{what="hv"}: Table 4.2, pg 94.
\cr
\code{what="all"}: Table 4.3, pg 97.
}

