% Generated by roxygen2 (4.0.1): do not edit by hand
\name{multi}
\alias{multi}
\alias{multi.coxph}
\title{Multiple \code{coxph} models}
\usage{
multi(x, ...)

\method{multi}{coxph}(x, ..., maxCoef = 5L, crit = c("aic", "aicc", "bic"),
  how = c("all", "evolve"), confSetSize = 100L, maxiter = 100L,
  bunch = 1000L, mutRate = 0.1, sexRate = 0.2, immRate = 0.3,
  deltaM = 1, deltaB = 1, conseq = 10L, report = TRUE)
}
\arguments{
\item{x}{An object of class \code{coxph}}

\item{...}{Not implemented}

\item{maxCoef}{Maximum no. of coefficients}

\item{crit}{Information criterion \dfn{IC}}

\item{how}{Method used to fit models. If \code{how="all"} (the default), all subsets of the
given model will be fit}

\item{confSetSize}{Size of returned confidence size. Number represents a row in the set.
(Columns represent parameters/coefficients in the models).}

\item{maxiter}{Maximum no. of iterations to use (for cox fitter).
Needs to be integer and should not
normally need to be > 100.}

\item{bunch}{When using \code{how="evolve"}:
no. of models to screen per generation}

\item{mutRate}{Mutation rate for new models
(both asexual and sexual selection). Should be in range \eqn{0-1}.}

\item{sexRate}{Sexual reproduction rate. Should be in range \eqn{0-1}.}

\item{immRate}{Immigration rate. Should be in range \eqn{0-1}.
Also \code{sexRate} + \code{immRate} should
not be \eqn{> 1}.}

\item{deltaM}{Target for change in mean IC determining convergence
when \code{how="evolve"}.
The last mean IC (from the best \code{confSetSize} models screened) is
compared with that from the most recently fitted \code{bunch}.}

\item{deltaB}{Change in best IC determining convergence of evolution.
This typically converges faster
than \code{deltaB}.}

\item{conseq}{Consecutive generations allowed which are 'divergent'
by both of the above criteria.
Algorithm will stop after this no. is reached.}

\item{report}{If \code{report=TRUE} (the default),
print report to screen during fitting.
Gives current change in best and mean IC as well as object size of
fitted models.}
}
\value{
A \code{data.table} with one row per model.
This is of \code{class} \code{multi.coxph}
which has it's own \code{plot} method.
Columns show the coefficients from the fitted model. Values of \eqn{0}
indicate coefficient was not included. The \code{data.table} is sorted by IC
and also gives a column for relative evidence weights.
These are generated from:
\deqn{ w_i = \exp (\frac{-IC_i - IC_{best}}{2})}{
 w[i] = exp[ (-IC[i] - IC[best] )/2] }
Where \eqn{IC_i}{IC[i]} is the information criterion for the given model, and
\eqn{IC_{best}}{IC[best]} is that for the best model yet fitted.
They are then scaled to sum to \eqn{1}.
}
\description{
Multiple \code{coxph} models


}
\details{
This is based loosely on \code{package:glmulti}
(although is admittedly less efficient).
A more detailed discussion of the issues involved in multiple model
fitting is presented in the reference paper describing
that package's implementation.
\cr \cr
It is designed for cases where there a large no. of candidate models
for a given dataset (currently only right-censored survival data).
First, the \code{model.matrix} for the given formula is constructed.
For those unfamiliar with \code{model.matrix}, a predictor given as
a \code{factor} is expanded to
it's design matrix, so that e.g. for 4 original \code{level}s
there will be 3 binary (\eqn{0/1}) columns.
Currently all levels of a factor are considered independently
when fitting models.
\cr
Thus there is one column for each coefficient in the original model.
\cr \cr
The original formula can include the following terms:
\code{offset}, \code{weight} and \code{strata}.
Other \emph{special} terms such as \code{cluster} are not currently supported.
The formula may contain interaction terms and other transformations.
\cr \cr
If \code{how="all"}, all possible combinations of these coefficients
are fitted (or up to \code{maxCoef} predictors if this is less).
\cr \cr
If \code{how="evolve"} the algorithm proceeds as follows:
\enumerate{
 \item Fit \code{bunch} random models and sort by IC
 \item Generate another \code{bunch} candidate models based on these.
\code{immRate} gives the proportion that will be completely
random new models.
\code{sexRate} gives the proportion that will be the
products of existing models.
These are a random combination of the first elements from model 1
and the last elements from model 2.
The sum of \code{immRate} and \code{sexRate} should thus be \eqn{<= 1}.
 \item Other models (asexual) will be selected from the existing pool of
fitted models with a likelihood inversely proportional to their IC
(i.e. lower IC - more likely).
Both these and those generated by sexual reproduction
have a chance of mutation (elements changing from \eqn{1} to \eqn{0} or vice versa)
given by \code{mutRate}.
 \item Fit new models (not already fitted).
 \item Proceed until model fitting
is 'divergent' \code{conseq} times then stop.
Divergent is here taken to mean that the targets for \emph{both}
\code{deltaM} and \code{deltaB} have not been met.
\cr
\code{deltaM} typically converges more slowly. Thus a large value of \code{deltaM} will
require new \code{bunch}es of models to be signifiantly better than the best
(size = \code{confSetSize}) existing candidates.
Negative values of \code{deltaM} (not typically recommended) are more permissive;
i.e. new models can be somewhat worse than those existing.
}
The models are returned in a \code{data.table},
with one row per model giving the fitted coefficients,
the IC for the model and the relative evidence weights.
}
\note{
The algorithm will tend to slow as the population of fitted models expands.
}
\examples{
set.seed(1)
df1 <- genSurvDf(b=1, c=5, f=0, model=FALSE)
multi(coxph(Surv(t1, e) ~ ., data=df1), crit="aic")
\dontrun{
### longer example
dt1 <- genSurvDt(b=1, c=30, f=0, model=FALSE)
multi(coxph(Surv(t1, e) ~ ., data=dt1),
maxCoef=8, crit="bic", how="evolve", deltaM=1, deltaB=1, conseq=10) }
}
\references{
Calgano V, de Mazancourt C, 2010.
glmulti: An R Package for Easy Automated Model Selection with (Generalized) Linear Models.
\emph{Journal of Statistical Software}. \bold{34}(12):1-29.
\href{http://www.jstatsoft.org/v34/i12/paper}{Available at JSS}.
}
\seealso{
\code{\link{ic}}

\code{\link{plot.MultiCoxph}}
}

