% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_network_R.R
\name{calc_network_R}
\alias{calc_network_R}
\title{Calculate the reproduction number (\eqn{R}) for a (heterogeneous)
network}
\usage{
calc_network_R(
  mean_num_contact,
  sd_num_contact,
  infect_duration,
  prob_transmission,
  age_range
)
}
\arguments{
\item{mean_num_contact}{A \code{numeric}, mean (average) number of new contacts
per unit time.}

\item{sd_num_contact}{A \code{numeric}, standard deviation of the number of new
contacts per unit time.}

\item{infect_duration}{A \code{numeric}, the duration of infectiousness.}

\item{prob_transmission}{A \code{numeric} probability of transmission per contact,
also known as \eqn{\beta}.}

\item{age_range}{A \code{numeric} vector with two elements, the lower and upper
age limits of individuals in the network.}
}
\value{
A named \code{numeric} vector of length 2, the unadjusted (\code{R})
and network adjusted (\code{R_net}) estimates of \eqn{R}.
}
\description{
The calculation of the reproduction number adjusting for
heterogeneity in number of contacts.
}
\examples{
# example using NATSAL data
calc_network_R(
  mean_num_contact = 14.1,
  sd_num_contact = 69.6,
  infect_duration = 1,
  prob_transmission = 1,
  age_range = c(16, 74)
)
}
