% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMTrainer.R
\name{LMTrainer}
\alias{LMTrainer}
\title{Linear Models Trainer}
\description{
Trains regression, lasso, ridge model in R
}
\details{
Trains linear models such as Logistic, Lasso or Ridge regression model. It is built on glmnet R package.
This class provides fit, predict, cross valdidation functions.
}
\examples{

## ------------------------------------------------
## Method `LMTrainer$new`
## ------------------------------------------------

\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
}

## ------------------------------------------------
## Method `LMTrainer$fit`
## ------------------------------------------------

\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$fit(X = housing, y = 'MEDV')
}

## ------------------------------------------------
## Method `LMTrainer$predict`
## ------------------------------------------------

\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$fit(X = housing, y = 'MEDV')
predictions <- lf$cv_predict(df = housing)
}

## ------------------------------------------------
## Method `LMTrainer$cv_model`
## ------------------------------------------------

\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$cv_model(X = housing, y = 'MEDV', nfolds = 5, parallel = FALSE)
}

## ------------------------------------------------
## Method `LMTrainer$cv_predict`
## ------------------------------------------------

\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$cv_model(X = housing, y = 'MEDV', nfolds = 5, parallel = FALSE)
predictions <- lf$cv_predict(df = housing)
}

## ------------------------------------------------
## Method `LMTrainer$get_importance`
## ------------------------------------------------

\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$cv_model(X = housing, y = 'MEDV', nfolds = 5, parallel = FALSE)
predictions <- lf$cv_predict(df = housing)
coefs <- lf$get_importance()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{family}}{type of regression to perform, values can be "gaussian" ,"binomial", "multinomial","mgaussian"}

\item{\code{weights}}{observation weights. Can be total counts if responses are proportion matrices. Default is 1 for each observation}

\item{\code{alpha}}{The elasticnet mixing parameter, alpha=1 is the lasso penalty, alpha=0 the ridge penalty, alpha=NULL is simple regression}

\item{\code{lambda}}{the number of lambda values - default is 100}

\item{\code{standardize}}{normalise the features in the given data}

\item{\code{standardize.response}}{normalise the dependent variable between 0 and 1, default = FALSE}

\item{\code{model}}{internal use}

\item{\code{cvmodel}}{internal use}

\item{\code{Flag}}{internal use}

\item{\code{is_lasso}}{internal use}

\item{\code{iid_names}}{internal use}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LMTrainer-new}{\code{LMTrainer$new()}}
\item \href{#method-LMTrainer-fit}{\code{LMTrainer$fit()}}
\item \href{#method-LMTrainer-predict}{\code{LMTrainer$predict()}}
\item \href{#method-LMTrainer-cv_model}{\code{LMTrainer$cv_model()}}
\item \href{#method-LMTrainer-cv_predict}{\code{LMTrainer$cv_predict()}}
\item \href{#method-LMTrainer-get_importance}{\code{LMTrainer$get_importance()}}
\item \href{#method-LMTrainer-clone}{\code{LMTrainer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LMTrainer-new"></a>}}
\if{latex}{\out{\hypertarget{method-LMTrainer-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LMTrainer$new(family, weights, alpha, lambda, standardize.response)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{family}}{character, type of regression to perform, values can be "gaussian" ,"binomial", "multinomial","mgaussian"}

\item{\code{weights}}{numeric, observation weights. Can be total counts if responses are proportion matrices. Default is 1 for each observation}

\item{\code{alpha}}{integer, The elasticnet mixing parameter, alpha=1 is the lasso penalty, alpha=0 the ridge penalty, alpha=NULL is simple regression}

\item{\code{lambda}}{integer, the number of lambda values - default is 100}

\item{\code{standardize.response}}{logical, normalise the dependent variable between 0 and 1, default = FALSE}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new `LMTrainer` object.
}

\subsection{Returns}{
A `LMTrainer` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LMTrainer-fit"></a>}}
\if{latex}{\out{\hypertarget{method-LMTrainer-fit}{}}}
\subsection{Method \code{fit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LMTrainer$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{data.frame containing train featuers}

\item{\code{y}}{character, name of target variable}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Fits the LMTrainer model on given data
}

\subsection{Returns}{
NULL, train the model and saves internally
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$fit(X = housing, y = 'MEDV')
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LMTrainer-predict"></a>}}
\if{latex}{\out{\hypertarget{method-LMTrainer-predict}{}}}
\subsection{Method \code{predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LMTrainer$predict(df, lambda = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{data.frame containing test features}

\item{\code{lambda}}{integer, the number of lambda values - default is 100. By default it picks the best value from the model.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns predictions for test data
}

\subsection{Returns}{
vector, a vector containing predictions
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$fit(X = housing, y = 'MEDV')
predictions <- lf$cv_predict(df = housing)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LMTrainer-cv_model"></a>}}
\if{latex}{\out{\hypertarget{method-LMTrainer-cv_model}{}}}
\subsection{Method \code{cv_model()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LMTrainer$cv_model(X, y, nfolds, parallel, type.measure = "deviance")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{data.frame containing test features}

\item{\code{y}}{character, name of target variable}

\item{\code{nfolds}}{integer, number of folds}

\item{\code{parallel}}{logical, if do parallel computation. Default=FALSE}

\item{\code{type.measure}}{character, evaluation metric type. Default = deviance}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Train regression model using cross validation
}

\subsection{Returns}{
NULL, trains the model and saves it in memory
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$cv_model(X = housing, y = 'MEDV', nfolds = 5, parallel = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LMTrainer-cv_predict"></a>}}
\if{latex}{\out{\hypertarget{method-LMTrainer-cv_predict}{}}}
\subsection{Method \code{cv_predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LMTrainer$cv_predict(df, lambda = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{data.frame containing test features}

\item{\code{lambda}}{integer, the number of lambda values - default is 100. By default it picks the best value from the model.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get predictions from the cross validated regression model
}

\subsection{Returns}{
vector a vector containing predicted values
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$cv_model(X = housing, y = 'MEDV', nfolds = 5, parallel = FALSE)
predictions <- lf$cv_predict(df = housing)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LMTrainer-get_importance"></a>}}
\if{latex}{\out{\hypertarget{method-LMTrainer-get_importance}{}}}
\subsection{Method \code{get_importance()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LMTrainer$get_importance()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get feature importance using model coefficients
}

\subsection{Returns}{
a matrix containing feature coefficients
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$cv_model(X = housing, y = 'MEDV', nfolds = 5, parallel = FALSE)
predictions <- lf$cv_predict(df = housing)
coefs <- lf$get_importance()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LMTrainer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LMTrainer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LMTrainer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
