% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomForest.R
\docType{data}
\name{RFTrainer}
\alias{RFTrainer}
\title{Random Forest Trainer}
\format{\code{\link{R6Class}} object.}
\usage{
RFTrainer
}
\description{
Trains a Random Forest model. A random forest is a meta estimator that fits a number of decision tree classifiers on various sub-samples of the dataset and use averaging to improve the predictive accuracy and control over-fitting.
This implementation uses ranger R package which provides faster model training.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
bst = RandomForestTrainer$new(n_estimators=100, max_features="auto", max_depth=5, min_node_size=1,
                              criterion, classification=1, class_weights, verbose=TRUE,
                              seed=42, always_split)
bst$fit(X_train, "target")
prediction <- bst$predict(X_test)
}
}

\section{Methods}{

\describe{
  \item{\code{$new()}}{Initialises an instance of random forest model}
  \item{\code{$fit()}}{fit model to an input train data and trains the model.}
  \item{\code{$predict()}}{returns predictions by fitting the trained model on test data.}
  \item{\code{$get_importance()}}{Get feature importance from the model}
}
}

\section{Arguments}{

\describe{
 \item{n_estimators}{the number of trees in the forest, default= 100}
 \item{max_features}{the number of features to consider when looking for the best split.
                     Possible values are \code{auto(default)} takes sqrt(num_of_features),
                         \code{sqrt} same as auto,
                         \code{log} takes log(num_of_features),
                         \code{none} takes all features}
 \item{max_depth}{the maximum depth of each tree}
 \item{min_node_size}{the minumum number of samples required to split an internal node}
 \item{criterion}{the function to measure the quality of split. For classification, \code{gini} is used which
     is a measure of gini index. For regression, the \code{variance} of responses is used.}
 \item{classification}{whether to train for classification (1) or regression (0)}
 \item{class_weights}{weights associated with the classes for sampling of training observation}
 \item{verbose}{show computation status and estimated runtime}
 \item{always_split}{vector of feature names to be always used for splitting}
 \item{seed}{seed value}
 \item{importance}{Variable importance mode, one of 'none', 'impurity', 'impurity_corrected', 'permutation'. The 'impurity' measure is the Gini index for classification, the variance of the responses for regression. Defaults to "impurity"}
}
}

\examples{
data("iris")
bst <- RFTrainer$new(n_estimators=50,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)
bst$fit(iris, 'Species')
predictions <- bst$predict(iris)
bst$get_importance()
}
\keyword{datasets}
