% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_summclust.R
\name{tidy.summclust}
\alias{tidy.summclust}
\title{S3 method to summarize objects of class boottest into tidy data.frame}
\usage{
\method{tidy}{summclust}(x, ...)
}
\arguments{
\item{x}{An object of class 'summclust'}

\item{...}{Other arguments}
}
\value{
A data.frame containing coefficient estimates,
t-statistics, standard errors, p-value, and confidence
intervals based on CRV3 variance-covariance matrix
and t(G-1) distribution
}
\description{
Obtain results from a \code{summclust} object in a tidy data frame.
}
\examples{

\donttest{
if(requireNamespace("summclust") && requireNamespace("haven")){

library(summclust)
library(haven)

nlswork <- read_dta("http://www.stata-press.com/data/r9/nlswork.dta")
# drop NAs at the moment
nlswork <- nlswork[, c("ln_wage", "grade", "age", "birth_yr", "union", "race", "msp", "ind_code")]
nlswork <- na.omit(nlswork)

lm_fit <- lm(
  ln_wage ~ union +  race + msp + as.factor(birth_yr) + as.factor(age) + as.factor(grade),
  data = nlswork)

res <- summclust(
   obj = lm_fit,
   params = c("msp", "union"),
   cluster = ~ind_code,
 )

 tidy(res)
}
}

}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
