#' @export
as.cuneiform <- function(x, ...) {
  UseMethod("as.cuneiform")
}

#' @export
as.cuneiform.default <- function(x, ...) {
  stop("Cannot coerce to cuneiform")
}

#' @export
as.cuneiform.character <- function(x, mapping = NULL, ...) {
  if(is.null(mapping)){
    path    <- system.file("extdata", "etcsl_mapping.txt", package = "sumer")
    mapping <- read.csv2(path, sep=";", na.strings="")
  }
  result <- rep("", length(x))

  for(i in 1: length(x)){
    if(x[i]==""){next}
    this_info  <- info(x[i], mapping=mapping)
    separators <- attr(this_info, "separators")
    symbols    <- this_info$sign

    cuneiform_text <- paste0(c("",symbols), separators, collapse="")
    cuneiform_text <- str_replace_all(cuneiform_text, "-", "")
    cuneiform_text <- str_replace_all(cuneiform_text, fixed("."), "")

    result[i] <- cuneiform_text
  }

  class(result) <- c("cuneiform", "character")

  return(result)
}

#' @exportS3Method print cuneiform
print.cuneiform <- function(x, ...){
  cat(x, sep="\n")
}
