% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hexmap.R
\name{create_hexmap}
\alias{create_hexmap}
\title{Create a tessellated hexagon map from a set of polygons}
\usage{
create_hexmap(
  shp,
  sf_id,
  hex_size = NULL,
  buffer_dist = NULL,
  hex_filter = 10,
  f_width = 30,
  focal_points = NULL,
  order_sf_id = NULL,
  export_shp = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{shp}{a shape file, if class is SPDF, will be converted to sf}

\item{sf_id}{name of a unique column that distinguishes areas}

\item{hex_size}{a float value in degrees for the diameter of the hexagons}

\item{buffer_dist}{distance in degrees to extend beyond the geometry provided}

\item{hex_filter}{amount of hexagons around centroid to consider}

\item{f_width}{the angle used to filter the grid points around a centroid}

\item{focal_points}{a data frame of reference locations when allocating
hexagons, capital cities of Australia are used in the example}

\item{order_sf_id}{a string name of a column to order by for allocating}

\item{export_shp}{export the simple features set}

\item{verbose}{a boolean to indicate whether to show function progress}
}
\value{
a data set containing longitude and latitude of allocated hexagon
points for each non null geometry passed in the shape file
}
\description{
Allocates each polygon in a shape file to a grid point to create a map of
tessellated hexagons. The spatial relationships of areas are preserved while
the geographic shape of each area is lost.
}
\examples{

data(tas_sa2)
data(capital_cities)
hexmap <- create_hexmap(
  shp = tas_lga,
  sf_id = "LGA_CODE16",
  focal_points = capital_cities, verbose = TRUE)

}
