% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_RandomRBFSubspaceGeneratorEvents.R
\name{DSD_RandomRBFSubspaceGeneratorEvents}
\alias{DSD_RandomRBFSubspaceGeneratorEvents}
\title{Synthetic Subspace Data Stream}
\usage{
DSD_RandomRBFSubspaceGeneratorEvents(numAtts = 5, numCluster = 5,
  numClusterRange = 0, avgSubspaceSize = 4, avgSubspaceSizeRange = 0,
  kernelRadii = 0.07, kernelRadiiRange = 0, numOverlappedCluster = 0,
  overlappingDegree = 0, densityRange = 0, noiseLevel = 0.1,
  noiseInCluster = F, speed = 200, speedRange = 0,
  eventFrequency = 30000, eventMergeSplit = F, eventDeleteCreate = F,
  subspaceEventFrequency = 0, decayHorizon = 1000, decayThreshold = 0.1,
  modelRandomSeed = sample.int(n = (2^31) - 1, 1),
  instanceRandomSeed = sample.int(n = (2^31) - 1, 1))
}
\arguments{
\item{numAtts}{the number of dimensions of the data stream.}

\item{numCluster}{the average number of clusters at any point in time.}

\item{numClusterRange}{amount by which the actual number of clusters can
deviate from numCluster.}

\item{avgSubspaceSize}{the average number of dimensions in the subspace of a
cluster.}

\item{avgSubspaceSizeRange}{the amount by which the number of dimensions can
deviate from avgSubspaceSize.}

\item{kernelRadii}{the average radii of the clusters in the model.}

\item{kernelRadiiRange}{the amount by which the radii can deviate from
kernelRadii.}

\item{numOverlappedCluster}{the number of overlapped clusters at the beginning
of the stream.}

\item{overlappingDegree}{how close the initially overlapped clusters are}

\item{densityRange}{how strongly the amount of points in each cluster differs
from each other. 0 means all clusters have the same size. 1 is the maximum
value.}

\item{noiseLevel}{amount of noise}

\item{noiseInCluster}{can noise be placed in a cluster?}

\item{speed}{every speed points, the clusters move by 0.01}

\item{speedRange}{speed/Velocity point offset}

\item{eventFrequency}{events happen every eventFrequency points if at least one event is enabled and numClusterRange is set}

\item{eventMergeSplit}{can clusters merge or split?}

\item{eventDeleteCreate}{can clusters be deleted or created?}

\item{subspaceEventFrequency}{Subspace event frequency by each cluster movement destination.}

\item{decayHorizon}{decay horizon}

\item{decayThreshold}{decay horizon threshold}

\item{modelRandomSeed}{number used to seed the RNG for the model}

\item{instanceRandomSeed}{number used to seed the RNG for the instances}
}
\description{
A Random data stream that generated data points that are clustered in several
subspaces.
}
