% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readwrite.R
\docType{data}
\name{readwrite}
\alias{PIPE_BOTH}
\alias{PIPE_STDERR}
\alias{PIPE_STDOUT}
\alias{process_close_input}
\alias{process_read}
\alias{process_write}
\alias{readwrite}
\title{Communicating with a Child Process}
\format{\code{PIPE_STDOUT}, \code{PIPE_STDERR} and \code{PIPE_BOTH}
        are single \code{character} values.}
\usage{
process_read(handle, pipe = PIPE_BOTH, timeout = TIMEOUT_IMMEDIATE,
  flush = TRUE)

process_write(handle, message)

process_close_input(handle)

PIPE_STDOUT

PIPE_STDERR

PIPE_BOTH
}
\arguments{
\item{handle}{Process handle obtained from \code{spawn_process}.}

\item{pipe}{Output stream identifier: \code{PIPE_STDOUT},
\code{PIPE_STDERR} or \code{PIPE_BOTH}.}

\item{timeout}{Optional timeout in milliseconds.}

\item{flush}{If there is any data within the given \code{timeout}
try again with \code{timeout=0} until C buffer is empty.}

\item{message}{Input for the child process.}
}
\value{
\code{process_read} returns a \code{list} containing either of
        or both keys: \emph{stdout} and \emph{stderr}; the value is in
        both cases a \code{character} vector which contains lines of
        child's output.

\code{process_write} returns the number of characters
        written.
}
\description{
\code{process_read()} reads data from one of the child process' streams,
\emph{standard output} or \emph{standard error output}, and returns
it as a \code{character} vector.

\code{process_write()} writes data into child's
\emph{standard input} stream.

\code{process_close_input()} closes the \emph{write} end
of the pipe whose \emph{read} end is the standard input stream of the
child process. This is a standard way to gracefully request the child
process to exit.

\code{PIPE_STDOUT}: read from child's standard output.

\code{PIPE_STDERR}: read from child's standard error
output.

\code{PIPE_BOTH}: read from both child's output streams:
standard output and standard error output.
}
\details{
If \code{flush=TRUE} in \code{process_read()} then the invocation of
the underlying \code{read()} \emph{system-call} will be repeated until
the pipe buffer is empty.

If \code{pipe} is set to either \code{PIPE_STDOUT} or \code{PIPE_STDERR},
the returned value is a single list with a single key, \emph{stdout} or
\emph{stderr}, respectively. If \code{pipe} is set to \code{PIPE_BOTH}
the returned \code{list} contains both keys. Values in the list are
\code{character} vectors of 0 or more elements, lines read from the
respective output stream of the child process.

For details on \code{timeout} see \code{\link{terminating}}.
}
\keyword{datasets}

