% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect-alignment.R
\name{token_is_on_aligned_line}
\alias{token_is_on_aligned_line}
\title{Check if tokens are aligned}
\usage{
token_is_on_aligned_line(pd_flat)
}
\arguments{
\item{pd_flat}{A flat parse table.}
}
\description{
If all tokens are aligned, \code{TRUE} is returned, otherwise \code{FALSE}. The
function only checks for alignment of function calls. This can be
recycled conveniently later if needed as a vector with length > 1.
}
\details{
Multiple lines are called aligned if the following conditions hold for all
but the first line of the expression:
\itemize{
\item lag spaces of column 1 must agree.
\item spacing around comma (0 before, > 1 after) and spacing around \code{=} (at least
one around).
\item all positions of commas of col > 2 must agree (needs recursive creation of
\code{text}).
}

Because of the last requirement, this function is very expensive to run. For
this reason, the following approach is taken:
\itemize{
\item Only invoke the function when certain that alignment is possible.
\item Check the cheap conditions first.
\item For the recursive creation of text, greedily check column by column to make
sure we can stop as soon as we found that columns are not aligned.
}
}
\examples{
library("magrittr")
withr::with_options(
  list(styler.cache_name = NULL), # temporarily deactivate cache
  {
    transformers <- tidyverse_style()
    pd_nested <- styler:::compute_parse_data_nested(c(
      "call(",
      "  ab = 1L,",
      "  a  = 2",
      ")"
    )) \%>\%
      styler:::post_visit(transformers$initialize)
    nest <- pd_nested$child[[1L]]
    styler:::token_is_on_aligned_line(nest)
  }
)
}
\keyword{internal}
