% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calculateAT.r
\name{calculateAT}
\alias{calculateAT}
\title{Calculate Analytical Threshold}
\usage{
calculateAT(data, ref = NULL, block.height = TRUE, height = 500,
  block.sample = TRUE, per.dye = TRUE, range.sample = 20,
  block.ils = TRUE, range.ils = 10, k = 3, rank.t = 0.99,
  alpha = 0.01, ignore.case = TRUE, word = FALSE, debug = FALSE)
}
\arguments{
\item{data}{a data frame containing at least 'Dye.Sample.Peak',
'Sample.File.Name', 'Marker', 'Allele', 'Height', and 'Data.Point'.}

\item{ref}{a data frame containing at least
'Sample.Name', 'Marker', 'Allele'.}

\item{block.height}{logical to indicate if high peaks should be blocked.}

\item{height}{integer for global lower peak height threshold for peaks
to be excluded from the analysis. Active if 'block.peak=TRUE.}

\item{block.sample}{logical to indicate if sample allelic peaks should be blocked.}

\item{per.dye}{logical TRUE if sample peaks should be blocked per dye channel.
FALSE if sample peaks should be blocked globally across dye channels.}

\item{range.sample}{integer to specify the blocking range in (+/-) data points.
Active if block.sample=TRUE.}

\item{block.ils}{logical to indicate if internal lane standard peaks should be blocked.}

\item{range.ils}{integer to specify the blocking range in (+/-) data points.
Active if block.ils=TRUE.}

\item{k}{numeric factor for the desired confidence level (method AT1).}

\item{rank.t}{numeric percentile rank threshold (method AT2).}

\item{alpha}{numeric one-sided confidence interval to obtain the
critical value from the t-distribution (method AT4).}

\item{ignore.case}{logical to indicate if sample matching should ignore case.}

\item{word}{logical to indicate if word boundaries should be added before sample matching.}

\item{debug}{logical to indicate if debug information should be printed.}
}
\value{
list of two data frames. The first with result per dye per sample,
 per sample, and all data for each method. The second is the complete percentile
 rank list.
}
\description{
Calculate analytical thresholds estimates.
}
\details{
Calculate the analytical threshold (AT) according to method 1, 2, and 4 as
recommended in the reference by analysing the background signal (noise).
Method 1: The average signal + 'k' * the standard deviation.
Method 2: The percentile rank method. The percentage of noise peaks below 'rank.t'.
Method 4: Utilize the mean and standard deviation and the critical value obtained
from the t-distribution for confidence interval 'alpha' (one-sided) and observed
peaks analysed (i.e. not blocked) minus one as degrees of freedom, and the number
of samples.
If samples containing DNA are used a range around the allelic peaks can be blocked
from the analysis to discard peaks higher than the noise. Blocking can be within
each dye or across all dye channels.
Similarily a range around the peaks of the internal lane standard (ILS) can be
blocked across all dye channels. Which can bleed-through in week samples
(i.e. negative controls)
}
\references{
J. Bregu et.al.,
  Analytical thresholds and sensitivity: establishing RFU thresholds for
  forensic DNA analysis, J. Forensic Sci. 58 (1) (2013) 120-129,
  ISSN 1556-4029, DOI: 10.1111/1556-4029.12008.
\url{http://onlinelibrary.wiley.com/doi/10.1111/1556-4029.12008/abstract}
}
\seealso{
\code{\link{blockAT}}, \code{\link{checkSubset}}
}

