% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calculateHeight}
\alias{calculateHeight}
\title{Calculate peak height.}
\usage{
calculateHeight(data, na = NULL, add = TRUE, exclude = NULL,
  debug = FALSE)
}
\arguments{
\item{data}{data.frame with at least columns 'Sample.Name' and 'Height'.}

\item{na}{replaces NA values.}

\item{add}{logical default is TRUE which will add/overwrite columns
'H', 'TPH', and 'Peaks' in the provided 'data'.}

\item{exclude}{character vector (case sensitive) e.g. "OL" excludes rows with
"OL" in the 'Allele' column.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with with at least columns 'Sample.Name', 'TPH', and 'Peaks'.
}
\description{
\code{calculateHeight} calculate peak height metrics for a sample.
}
\details{
Calculates the average peak height (H) and/or the total peak height (TPH) for each sample.
To enable calculation of H the sample data must contain a column "Heterozygous",
where 1 = heterozygous loci, and 0 = homozygous loci as known from the reference sample.
Calculates H according to the formula:
\eqn{H = sum(peak heights)/(n[het] + 2n[hom]}
Where:
n[het] = number of observed heterozygous alleles
n[hom] = number of observed homozygous alleles
}
\references{
Torben Tvedebrink, Poul Svante Eriksen, Helle Smidt Mogensen, Niels Morling,
 Evaluating the weight of evidence by using quantitative short tandem repeat data in DNA mixtures
 Journal of the Royal Statistical Society: Series C (Applied Statistics),
 Volume 59, Issue 5, 2010,
 Pages 855-874, 10.1111/j.1467-9876.2010.00722.x.
\url{http://dx.doi.org/10.1111/j.1467-9876.2010.00722.x}
}

