% Generated by roxygen2 (4.0.2): do not edit by hand
\name{addData}
\alias{addData}
\title{Adds new data columns to a data frame}
\usage{
addData(data, new.data, by.col, then.by.col = NULL, exact = TRUE,
  ignore.case = TRUE, debug = FALSE)
}
\arguments{
\item{data}{Data frame containing your main data.}

\item{new.data}{Data frame containing information you want to add to 'data'.}

\item{by.col}{character, key column.}

\item{then.by.col}{character, key column level 2.}

\item{exact}{logical, TRUE matches keys exact.}

\item{ignore.case}{logical, TRUE ignore case.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame the original data frame containing additional columns.
}
\description{
\code{addData} Adds columns in 'new.data' to 'data' by column 'by.col'.
}
\details{
Information in columns in data frame 'new.data' is added to data frame 'data'
based on value in column 'by.col' and optionally on 'then.by.col'.
}
\examples{
# Get marker names and alleles for Promega PowerPlex ESX 17.
x <- getKit("ESX17", what="Allele")
# Get marker names and colors for Promega PowerPlex ESX 17.
y <- getKit("ESX17", what="Color")
# Add color information to allele information.
z <- addData(data=x, new.data=y, by.col="Marker")
print(x)
print(y)
print(z)
}

