context("calculateStutter")

################################################################################
# TODO LIST
# TODO: ...

################################################################################
# CHANGE LOG
# dd.mm.yyyy: ...
# 
# test_dir("inst/tests/")
# test_file("tests/testthat/test-calculateStutter.r")
# test_dir("tests/testthat")

test_that("calculateStutter", {

  # Get test data.
  data(set4)
  data(ref4)

  # Get sample A2.1.
  setA1 <- set4[set4$Sample.Name == "03-A2.1",]
  
  # TEST 01 -------------------------------------------------------------------

  # Warn that 'Height' is not numeric.
  # expect_that(calculateStutter(data=setA1, ref=ref4), gives_warning())
  
  # TEST 02 -------------------------------------------------------------------
  # 1 Back, 0 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=1, forward=0, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)

  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0264))
  expect_that(round(res$Ratio[2], 4), equals(0.0889))
  expect_that(round(res$Ratio[3], 4), equals(0.1216))
  expect_that(round(res$Ratio[4], 4), equals(0.0768))
  expect_that(round(res$Ratio[5], 4), equals(0.0961))
  expect_that(round(res$Ratio[6], 4), equals(0.0417))
  expect_that(round(res$Ratio[7], 4), equals(0.0782))
  expect_that(round(res$Ratio[8], 4), equals(0.032))
  expect_that(round(res$Ratio[9], 4), equals(0.1195))
  expect_that(round(res$Ratio[10], 4), equals(0.0806))
  expect_that(round(res$Ratio[11], 4), equals(0.0921))
  expect_that(round(res$Ratio[12], 4), equals(0.0522))
  expect_that(round(res$Ratio[13], 4), equals(0.0506))
  expect_that(round(res$Ratio[14], 4), equals(0.0592))
  expect_that(round(res$Ratio[15], 4), equals(0.0091))
  expect_that(round(res$Ratio[16], 4), equals(0.0893))
  expect_that(round(res$Ratio[17], 4), equals(0.0655))
  expect_that(round(res$Ratio[18], 4), equals(0.1052))
  expect_that(round(res$Ratio[19], 4), equals(0.1832))
  expect_that(round(res$Ratio[20], 4), equals(0.0525))
  expect_that(round(res$Ratio[21], 4), equals(0.0804))
  expect_that(round(res$Ratio[22], 4), equals(0.0044))
  expect_that(round(res$Ratio[23], 4), equals(0.0801))
  expect_that(round(res$Ratio[24], 4), equals(0.0493))
  expect_that(round(res$Ratio[25], 4), equals(0.1376))

  # Check result: Type.
  expect_that(res$Type[1], equals(-1))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-1))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(-1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(-1))
  expect_that(res$Type[14], equals(-1))
  expect_that(res$Type[15], equals(-0.8))
  expect_that(res$Type[16], equals(-1))
  expect_that(res$Type[17], equals(-1))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(-1))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(-1))
  expect_that(res$Type[22], equals(-0.8))
  expect_that(res$Type[23], equals(-1))
  expect_that(res$Type[24], equals(-0.8))
  expect_that(res$Type[25], equals(-1))
  
  # TEST 03 -------------------------------------------------------------------
  # 1 Back, 1 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=1, forward=1, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0264))
  expect_that(round(res$Ratio[2], 4), equals(0.0889))
  expect_that(round(res$Ratio[3], 4), equals(0.0185))
  expect_that(round(res$Ratio[4], 4), equals(0.1216))
  expect_that(round(res$Ratio[5], 4), equals(0.0142))
  expect_that(round(res$Ratio[6], 4), equals(0.0768))
  expect_that(round(res$Ratio[7], 4), equals(0.0961))
  expect_that(round(res$Ratio[8], 4), equals(0.0417))
  expect_that(round(res$Ratio[9], 4), equals(0.009))
  expect_that(round(res$Ratio[10], 4), equals(0.0782))
  expect_that(round(res$Ratio[11], 4), equals(0.0086))
  expect_that(round(res$Ratio[12], 4), equals(0.032))
  expect_that(round(res$Ratio[13], 4), equals(0.0136))
  expect_that(round(res$Ratio[14], 4), equals(0.1195))
  expect_that(round(res$Ratio[15], 4), equals(0.0624))
  expect_that(round(res$Ratio[16], 4), equals(0.0806))
  expect_that(round(res$Ratio[17], 4), equals(0.0522))
  expect_that(round(res$Ratio[18], 4), equals(0.0064))
  expect_that(round(res$Ratio[19], 4), equals(0.0506))
  expect_that(round(res$Ratio[20], 4), equals(0.0053))
  expect_that(round(res$Ratio[21], 4), equals(0.0592))
  expect_that(round(res$Ratio[22], 4), equals(0.0091))
  expect_that(round(res$Ratio[23], 4), equals(0.0053))
  expect_that(round(res$Ratio[24], 4), equals(0.0893))
  expect_that(round(res$Ratio[25], 4), equals(0.0078))
  expect_that(round(res$Ratio[26], 4), equals(0.0057))
  expect_that(round(res$Ratio[27], 4), equals(0.0655))
  expect_that(round(res$Ratio[28], 4), equals(0.0116))
  expect_that(round(res$Ratio[29], 4), equals(0.1052))
  expect_that(round(res$Ratio[30], 4), equals(0.0038))
  expect_that(round(res$Ratio[31], 4), equals(0.1832))
  expect_that(round(res$Ratio[32], 4), equals(0.0525))
  expect_that(round(res$Ratio[33], 4), equals(0.0044))
  expect_that(round(res$Ratio[34], 4), equals(0.0801))
  expect_that(round(res$Ratio[35], 4), equals(0.0493))
  expect_that(round(res$Ratio[36], 4), equals(0.0046))
  expect_that(round(res$Ratio[37], 4), equals(0.1376))
  expect_that(round(res$Ratio[38], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-1))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(1))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(-1))
  expect_that(res$Type[15], equals(1))
  expect_that(res$Type[16], equals(-1))
  expect_that(res$Type[17], equals(-1))
  expect_that(res$Type[18], equals(1))
  expect_that(res$Type[19], equals(-1))
  expect_that(res$Type[20], equals(1))
  expect_that(res$Type[21], equals(-1))
  expect_that(res$Type[22], equals(-0.8))
  expect_that(res$Type[23], equals(1))
  expect_that(res$Type[24], equals(-1))
  expect_that(res$Type[25], equals(1))
  expect_that(res$Type[26], equals(1))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(1))
  expect_that(res$Type[29], equals(-1))
  expect_that(res$Type[30], equals(1))
  expect_that(res$Type[31], equals(-1))
  expect_that(res$Type[32], equals(-1))
  expect_that(res$Type[33], equals(-0.8))
  expect_that(res$Type[34], equals(-1))
  expect_that(res$Type[35], equals(-0.8))
  expect_that(res$Type[36], equals(1))
  expect_that(res$Type[37], equals(-1))
  expect_that(res$Type[38], equals(1))

  # TEST 04 -------------------------------------------------------------------
  # 1 Back, 2 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=1, forward=2, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0264))
  expect_that(round(res$Ratio[2], 4), equals(0.0889))
  expect_that(round(res$Ratio[3], 4), equals(0.0185))
  expect_that(round(res$Ratio[4], 4), equals(0.0142))
  expect_that(round(res$Ratio[5], 4), equals(0.0768))
  expect_that(round(res$Ratio[6], 4), equals(0.0961))
  expect_that(round(res$Ratio[7], 4), equals(0.0417))
  expect_that(round(res$Ratio[8], 4), equals(0.009))
  expect_that(round(res$Ratio[9], 4), equals(0.0086))
  expect_that(round(res$Ratio[10], 4), equals(0.032))
  expect_that(round(res$Ratio[11], 4), equals(0.0136))
  expect_that(round(res$Ratio[12], 4), equals(0.1195))
  expect_that(round(res$Ratio[13], 4), equals(0.0624))
  expect_that(round(res$Ratio[14], 4), equals(0.0806))
  expect_that(round(res$Ratio[15], 4), equals(0.0522))
  expect_that(round(res$Ratio[16], 4), equals(0.0064))
  expect_that(round(res$Ratio[17], 4), equals(0.0053))
  expect_that(round(res$Ratio[18], 4), equals(0.0592))
  expect_that(round(res$Ratio[19], 4), equals(0.0091))
  expect_that(round(res$Ratio[20], 4), equals(0.0053))
  expect_that(round(res$Ratio[21], 4), equals(0.0095))
  expect_that(round(res$Ratio[22], 4), equals(0.0893))
  expect_that(round(res$Ratio[23], 4), equals(0.0078))
  expect_that(round(res$Ratio[24], 4), equals(0.0057))
  expect_that(round(res$Ratio[25], 4), equals(0.0116))
  expect_that(round(res$Ratio[26], 4), equals(0.1052))
  expect_that(round(res$Ratio[27], 4), equals(0.0038))
  expect_that(round(res$Ratio[28], 4), equals(0.011))
  expect_that(round(res$Ratio[29], 4), equals(0.1832))
  expect_that(round(res$Ratio[30], 4), equals(0.0525))
  expect_that(round(res$Ratio[31], 4), equals(0.0801))
  expect_that(round(res$Ratio[32], 4), equals(0.0493))
  expect_that(round(res$Ratio[33], 4), equals(0.0046))
  expect_that(round(res$Ratio[34], 4), equals(0.1376))
  expect_that(round(res$Ratio[35], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-1))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(1))
  expect_that(res$Type[4], equals(1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(-1))
  expect_that(res$Type[15], equals(-1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(1))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(-0.8))
  expect_that(res$Type[20], equals(1))
  expect_that(res$Type[21], equals(2))
  expect_that(res$Type[22], equals(-1))
  expect_that(res$Type[23], equals(1))
  expect_that(res$Type[24], equals(1))
  expect_that(res$Type[25], equals(1))
  expect_that(res$Type[26], equals(-1))
  expect_that(res$Type[27], equals(1))
  expect_that(res$Type[28], equals(2))
  expect_that(res$Type[29], equals(-1))
  expect_that(res$Type[30], equals(-1))
  expect_that(res$Type[31], equals(-1))
  expect_that(res$Type[32], equals(-0.8))
  expect_that(res$Type[33], equals(1))
  expect_that(res$Type[34], equals(-1))
  expect_that(res$Type[35], equals(1))
  
  # TEST 04 -------------------------------------------------------------------
  # 1 Back, 3 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=1, forward=3, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0264))
  expect_that(round(res$Ratio[2], 4), equals(0.0889))
  expect_that(round(res$Ratio[3], 4), equals(0.0185))
  expect_that(round(res$Ratio[4], 4), equals(0.0768))
  expect_that(round(res$Ratio[5], 4), equals(0.0961))
  expect_that(round(res$Ratio[6], 4), equals(0.0417))
  expect_that(round(res$Ratio[7], 4), equals(0.009))
  expect_that(round(res$Ratio[8], 4), equals(0.032))
  expect_that(round(res$Ratio[9], 4), equals(0.0136))
  expect_that(round(res$Ratio[10], 4), equals(0.0082))
  expect_that(round(res$Ratio[11], 4), equals(0.1195))
  expect_that(round(res$Ratio[12], 4), equals(0.0624))
  expect_that(round(res$Ratio[13], 4), equals(0.0806))
  expect_that(round(res$Ratio[14], 4), equals(0.0522))
  expect_that(round(res$Ratio[15], 4), equals(0.0064))
  expect_that(round(res$Ratio[16], 4), equals(0.0592))
  expect_that(round(res$Ratio[17], 4), equals(0.0091))
  expect_that(round(res$Ratio[18], 4), equals(0.0053))
  expect_that(round(res$Ratio[19], 4), equals(0.0095))
  expect_that(round(res$Ratio[20], 4), equals(0.0076))
  expect_that(round(res$Ratio[21], 4), equals(0.0078))
  expect_that(round(res$Ratio[22], 4), equals(0.0057))
  expect_that(round(res$Ratio[23], 4), equals(0.1052))
  expect_that(round(res$Ratio[24], 4), equals(0.0038))
  expect_that(round(res$Ratio[25], 4), equals(0.011))
  expect_that(round(res$Ratio[26], 4), equals(0.0525))
  expect_that(round(res$Ratio[27], 4), equals(0.0801))
  expect_that(round(res$Ratio[28], 4), equals(0.0493))
  expect_that(round(res$Ratio[29], 4), equals(0.0046))
  expect_that(round(res$Ratio[30], 4), equals(0.1376))
  expect_that(round(res$Ratio[31], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-1))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(1))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(3))
  expect_that(res$Type[11], equals(-1))
  expect_that(res$Type[12], equals(1))
  expect_that(res$Type[13], equals(-1))
  expect_that(res$Type[14], equals(-1))
  expect_that(res$Type[15], equals(1))
  expect_that(res$Type[16], equals(-1))
  expect_that(res$Type[17], equals(-0.8))
  expect_that(res$Type[18], equals(1))
  expect_that(res$Type[19], equals(2))
  expect_that(res$Type[20], equals(2.2))
  expect_that(res$Type[21], equals(1))
  expect_that(res$Type[22], equals(1))
  expect_that(res$Type[23], equals(-1))
  expect_that(res$Type[24], equals(1))
  expect_that(res$Type[25], equals(2))
  expect_that(res$Type[26], equals(-1))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(-0.8))
  expect_that(res$Type[29], equals(1))
  expect_that(res$Type[30], equals(-1))
  expect_that(res$Type[31], equals(1))
  
  # TEST 05 -------------------------------------------------------------------
  # 2 Back, 0 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=2, forward=0, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0062))
  expect_that(round(res$Ratio[4], 4), equals(0.0889))
  expect_that(round(res$Ratio[5], 4), equals(0.0243))
  expect_that(round(res$Ratio[6], 4), equals(0.1216))
  expect_that(round(res$Ratio[7], 4), equals(0.0768))
  expect_that(round(res$Ratio[8], 4), equals(0.0961))
  expect_that(round(res$Ratio[9], 4), equals(0.0417))
  expect_that(round(res$Ratio[10], 4), equals(0.009))
  expect_that(round(res$Ratio[11], 4), equals(0.0782))
  expect_that(round(res$Ratio[12], 4), equals(0.032))
  expect_that(round(res$Ratio[13], 4), equals(0.0093))
  expect_that(round(res$Ratio[14], 4), equals(0.1195))
  expect_that(round(res$Ratio[15], 4), equals(0.0921))
  expect_that(round(res$Ratio[16], 4), equals(0.0522))
  expect_that(round(res$Ratio[17], 4), equals(0.0067))
  expect_that(round(res$Ratio[18], 4), equals(0.0506))
  expect_that(round(res$Ratio[19], 4), equals(0.0592))
  expect_that(round(res$Ratio[20], 4), equals(0.0091))
  expect_that(round(res$Ratio[21], 4), equals(0.0097))
  expect_that(round(res$Ratio[22], 4), equals(0.0078))
  expect_that(round(res$Ratio[23], 4), equals(0.0893))
  expect_that(round(res$Ratio[24], 4), equals(0.0057))
  expect_that(round(res$Ratio[25], 4), equals(0.0655))
  expect_that(round(res$Ratio[26], 4), equals(0.0062))
  expect_that(round(res$Ratio[27], 4), equals(0.1052))
  expect_that(round(res$Ratio[28], 4), equals(0.015))
  expect_that(round(res$Ratio[29], 4), equals(0.1832))
  expect_that(round(res$Ratio[30], 4), equals(0.0804))
  expect_that(round(res$Ratio[31], 4), equals(0.0044))
  expect_that(round(res$Ratio[32], 4), equals(0.0054))
  expect_that(round(res$Ratio[33], 4), equals(0.006))
  expect_that(round(res$Ratio[34], 4), equals(0.0801))
  expect_that(round(res$Ratio[35], 4), equals(0.0493))
  expect_that(round(res$Ratio[36], 4), equals(0.0099))
  expect_that(round(res$Ratio[37], 4), equals(0.1376))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-2))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(-2))
  expect_that(res$Type[11], equals(-1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(-2))
  expect_that(res$Type[14], equals(-1))
  expect_that(res$Type[15], equals(-1))
  expect_that(res$Type[16], equals(-1))
  expect_that(res$Type[17], equals(-2))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(-1))
  expect_that(res$Type[20], equals(-0.8))
  expect_that(res$Type[21], equals(-2))
  expect_that(res$Type[22], equals(-1.8))
  expect_that(res$Type[23], equals(-1))
  expect_that(res$Type[24], equals(-1.7))
  expect_that(res$Type[25], equals(-1))
  expect_that(res$Type[26], equals(-2))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(-2))
  expect_that(res$Type[29], equals(-1))
  expect_that(res$Type[30], equals(-1))
  expect_that(res$Type[31], equals(-0.8))
  expect_that(res$Type[32], equals(-2))
  expect_that(res$Type[33], equals(-1.8))
  expect_that(res$Type[34], equals(-1))
  expect_that(res$Type[35], equals(-0.8))
  expect_that(res$Type[36], equals(-2))
  expect_that(res$Type[37], equals(-1))
  
  # TEST 06 -------------------------------------------------------------------
  # 2 Back, 1 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=2, forward=1, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0062))
  expect_that(round(res$Ratio[4], 4), equals(0.0889))
  expect_that(round(res$Ratio[5], 4), equals(0.1216))
  expect_that(round(res$Ratio[6], 4), equals(0.0142))
  expect_that(round(res$Ratio[7], 4), equals(0.0768))
  expect_that(round(res$Ratio[8], 4), equals(0.0961))
  expect_that(round(res$Ratio[9], 4), equals(0.0417))
  expect_that(round(res$Ratio[10], 4), equals(0.0782))
  expect_that(round(res$Ratio[11], 4), equals(0.0086))
  expect_that(round(res$Ratio[12], 4), equals(0.032))
  expect_that(round(res$Ratio[13], 4), equals(0.0136))
  expect_that(round(res$Ratio[14], 4), equals(0.0093))
  expect_that(round(res$Ratio[15], 4), equals(0.1195))
  expect_that(round(res$Ratio[16], 4), equals(0.0624))
  expect_that(round(res$Ratio[17], 4), equals(0.0522))
  expect_that(round(res$Ratio[18], 4), equals(0.0506))
  expect_that(round(res$Ratio[19], 4), equals(0.0053))
  expect_that(round(res$Ratio[20], 4), equals(0.0592))
  expect_that(round(res$Ratio[21], 4), equals(0.0091))
  expect_that(round(res$Ratio[22], 4), equals(0.0053))
  expect_that(round(res$Ratio[23], 4), equals(0.0097))
  expect_that(round(res$Ratio[24], 4), equals(0.0078))
  expect_that(round(res$Ratio[25], 4), equals(0.0893))
  expect_that(round(res$Ratio[26], 4), equals(0.0078))
  expect_that(round(res$Ratio[27], 4), equals(0.0655))
  expect_that(round(res$Ratio[28], 4), equals(0.0116))
  expect_that(round(res$Ratio[29], 4), equals(0.0062))
  expect_that(round(res$Ratio[30], 4), equals(0.1052))
  expect_that(round(res$Ratio[31], 4), equals(0.0038))
  expect_that(round(res$Ratio[32], 4), equals(0.015))
  expect_that(round(res$Ratio[33], 4), equals(0.1832))
  expect_that(round(res$Ratio[34], 4), equals(0.0044))
  expect_that(round(res$Ratio[35], 4), equals(0.0054))
  expect_that(round(res$Ratio[36], 4), equals(0.006))
  expect_that(round(res$Ratio[37], 4), equals(0.0801))
  expect_that(round(res$Ratio[38], 4), equals(0.0493))
  expect_that(round(res$Ratio[39], 4), equals(0.0046))
  expect_that(round(res$Ratio[40], 4), equals(0.0099))
  expect_that(round(res$Ratio[41], 4), equals(0.1376))
  expect_that(round(res$Ratio[42], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(-2))
  expect_that(res$Type[15], equals(-1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(-1))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(1))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(-0.8))
  expect_that(res$Type[22], equals(1))
  expect_that(res$Type[23], equals(-2))
  expect_that(res$Type[24], equals(-1.8))
  expect_that(res$Type[25], equals(-1))
  expect_that(res$Type[26], equals(1))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(1))
  expect_that(res$Type[29], equals(-2))
  expect_that(res$Type[30], equals(-1))
  expect_that(res$Type[31], equals(1))
  expect_that(res$Type[32], equals(-2))
  expect_that(res$Type[33], equals(-1))
  expect_that(res$Type[34], equals(-0.8))
  expect_that(res$Type[35], equals(-2))
  expect_that(res$Type[36], equals(-1.8))
  expect_that(res$Type[37], equals(-1))
  expect_that(res$Type[38], equals(-0.8))
  expect_that(res$Type[39], equals(1))
  expect_that(res$Type[40], equals(-2))
  expect_that(res$Type[41], equals(-1))
  expect_that(res$Type[42], equals(1))
  
  # TEST 07 -------------------------------------------------------------------
  # 2 Back, 2 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=2, forward=2, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0062))
  expect_that(round(res$Ratio[4], 4), equals(0.0889))
  expect_that(round(res$Ratio[5], 4), equals(0.0142))
  expect_that(round(res$Ratio[6], 4), equals(0.0768))
  expect_that(round(res$Ratio[7], 4), equals(0.0961))
  expect_that(round(res$Ratio[8], 4), equals(0.0417))
  expect_that(round(res$Ratio[9], 4), equals(0.0086))
  expect_that(round(res$Ratio[10], 4), equals(0.032))
  expect_that(round(res$Ratio[11], 4), equals(0.0136))
  expect_that(round(res$Ratio[12], 4), equals(0.0093))
  expect_that(round(res$Ratio[13], 4), equals(0.1195))
  expect_that(round(res$Ratio[14], 4), equals(0.0624))
  expect_that(round(res$Ratio[15], 4), equals(0.0522))
  expect_that(round(res$Ratio[16], 4), equals(0.0053))
  expect_that(round(res$Ratio[17], 4), equals(0.0592))
  expect_that(round(res$Ratio[18], 4), equals(0.0091))
  expect_that(round(res$Ratio[19], 4), equals(0.0053))
  expect_that(round(res$Ratio[20], 4), equals(0.0078))
  expect_that(round(res$Ratio[21], 4), equals(0.0893))
  expect_that(round(res$Ratio[22], 4), equals(0.0078))
  expect_that(round(res$Ratio[23], 4), equals(0.0116))
  expect_that(round(res$Ratio[24], 4), equals(0.0062))
  expect_that(round(res$Ratio[25], 4), equals(0.1052))
  expect_that(round(res$Ratio[26], 4), equals(0.0038))
  expect_that(round(res$Ratio[27], 4), equals(0.1832))
  expect_that(round(res$Ratio[28], 4), equals(0.0054))
  expect_that(round(res$Ratio[29], 4), equals(0.006))
  expect_that(round(res$Ratio[30], 4), equals(0.0801))
  expect_that(round(res$Ratio[31], 4), equals(0.0493))
  expect_that(round(res$Ratio[32], 4), equals(0.0046))
  expect_that(round(res$Ratio[33], 4), equals(0.0099))
  expect_that(round(res$Ratio[34], 4), equals(0.1376))
  expect_that(round(res$Ratio[35], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-2))
  expect_that(res$Type[13], equals(-1))
  expect_that(res$Type[14], equals(1))
  expect_that(res$Type[15], equals(-1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(-1))
  expect_that(res$Type[18], equals(-0.8))
  expect_that(res$Type[19], equals(1))
  expect_that(res$Type[20], equals(-1.8))
  expect_that(res$Type[21], equals(-1))
  expect_that(res$Type[22], equals(1))
  expect_that(res$Type[23], equals(1))
  expect_that(res$Type[24], equals(-2))
  expect_that(res$Type[25], equals(-1))
  expect_that(res$Type[26], equals(1))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(-2))
  expect_that(res$Type[29], equals(-1.8))
  expect_that(res$Type[30], equals(-1))
  expect_that(res$Type[31], equals(-0.8))
  expect_that(res$Type[32], equals(1))
  expect_that(res$Type[33], equals(-2))
  expect_that(res$Type[34], equals(-1))
  expect_that(res$Type[35], equals(1))
  
  
  # TEST 08 -------------------------------------------------------------------
  # 2 Back, 3 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=2, forward=3, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0062))
  expect_that(round(res$Ratio[4], 4), equals(0.0889))
  expect_that(round(res$Ratio[5], 4), equals(0.0768))
  expect_that(round(res$Ratio[6], 4), equals(0.0961))
  expect_that(round(res$Ratio[7], 4), equals(0.0417))
  expect_that(round(res$Ratio[8], 4), equals(0.032))
  expect_that(round(res$Ratio[9], 4), equals(0.0136))
  expect_that(round(res$Ratio[10], 4), equals(0.1195))
  expect_that(round(res$Ratio[11], 4), equals(0.0624))
  expect_that(round(res$Ratio[12], 4), equals(0.0522))
  expect_that(round(res$Ratio[13], 4), equals(0.0592))
  expect_that(round(res$Ratio[14], 4), equals(0.0091))
  expect_that(round(res$Ratio[15], 4), equals(0.0053))
  expect_that(round(res$Ratio[16], 4), equals(0.0078))
  expect_that(round(res$Ratio[17], 4), equals(0.0062))
  expect_that(round(res$Ratio[18], 4), equals(0.1052))
  expect_that(round(res$Ratio[19], 4), equals(0.0038))
  expect_that(round(res$Ratio[20], 4), equals(0.0054))
  expect_that(round(res$Ratio[21], 4), equals(0.006))
  expect_that(round(res$Ratio[22], 4), equals(0.0801))
  expect_that(round(res$Ratio[23], 4), equals(0.0493))
  expect_that(round(res$Ratio[24], 4), equals(0.0046))
  expect_that(round(res$Ratio[25], 4), equals(0.0099))
  expect_that(round(res$Ratio[26], 4), equals(0.1376))
  expect_that(round(res$Ratio[27], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(-1))
  expect_that(res$Type[14], equals(-0.8))
  expect_that(res$Type[15], equals(1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(-2))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(1))
  expect_that(res$Type[20], equals(-2))
  expect_that(res$Type[21], equals(-1.8))
  expect_that(res$Type[22], equals(-1))
  expect_that(res$Type[23], equals(-0.8))
  expect_that(res$Type[24], equals(1))
  expect_that(res$Type[25], equals(-2))
  expect_that(res$Type[26], equals(-1))
  expect_that(res$Type[27], equals(1))
  
  # TEST 09 -------------------------------------------------------------------
  # 3 Back, 0 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=3, forward=0, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0243))
  expect_that(round(res$Ratio[4], 4), equals(0.1216))
  expect_that(round(res$Ratio[5], 4), equals(0.0768))
  expect_that(round(res$Ratio[6], 4), equals(0.0961))
  expect_that(round(res$Ratio[7], 4), equals(0.009))
  expect_that(round(res$Ratio[8], 4), equals(0.0782))
  expect_that(round(res$Ratio[9], 4), equals(0.032))
  expect_that(round(res$Ratio[10], 4), equals(0.0093))
  expect_that(round(res$Ratio[11], 4), equals(0.1195))
  expect_that(round(res$Ratio[12], 4), equals(0.0921))
  expect_that(round(res$Ratio[13], 4), equals(0.0067))
  expect_that(round(res$Ratio[14], 4), equals(0.0506))
  expect_that(round(res$Ratio[15], 4), equals(0.0592))
  expect_that(round(res$Ratio[16], 4), equals(0.0091))
  expect_that(round(res$Ratio[17], 4), equals(0.0054))
  expect_that(round(res$Ratio[18], 4), equals(0.0097))
  expect_that(round(res$Ratio[19], 4), equals(0.0078))
  expect_that(round(res$Ratio[20], 4), equals(0.0893))
  expect_that(round(res$Ratio[21], 4), equals(0.0057))
  expect_that(round(res$Ratio[22], 4), equals(0.0655))
  expect_that(round(res$Ratio[23], 4), equals(0.0062))
  expect_that(round(res$Ratio[24], 4), equals(0.1052))
  expect_that(round(res$Ratio[25], 4), equals(0.0052))
  expect_that(round(res$Ratio[26], 4), equals(0.015))
  expect_that(round(res$Ratio[27], 4), equals(0.1832))
  expect_that(round(res$Ratio[28], 4), equals(0.0804))
  expect_that(round(res$Ratio[29], 4), equals(0.0044))
  expect_that(round(res$Ratio[30], 4), equals(0.0054))
  expect_that(round(res$Ratio[31], 4), equals(0.006))
  expect_that(round(res$Ratio[32], 4), equals(0.0801))
  expect_that(round(res$Ratio[33], 4), equals(0.0493))
  expect_that(round(res$Ratio[34], 4), equals(0.0099))
  expect_that(round(res$Ratio[35], 4), equals(0.1376))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-2))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(-2))
  expect_that(res$Type[11], equals(-1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(-2))
  expect_that(res$Type[14], equals(-1))
  expect_that(res$Type[15], equals(-1))
  expect_that(res$Type[16], equals(-0.8))
  expect_that(res$Type[17], equals(-3))
  expect_that(res$Type[18], equals(-2))
  expect_that(res$Type[19], equals(-1.8))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(-1.7))
  expect_that(res$Type[22], equals(-1))
  expect_that(res$Type[23], equals(-2))
  expect_that(res$Type[24], equals(-1))
  expect_that(res$Type[25], equals(-3))
  expect_that(res$Type[26], equals(-2))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(-1))
  expect_that(res$Type[29], equals(-0.8))
  expect_that(res$Type[30], equals(-2))
  expect_that(res$Type[31], equals(-1.8))
  expect_that(res$Type[32], equals(-1))
  expect_that(res$Type[33], equals(-0.8))
  expect_that(res$Type[34], equals(-2))
  expect_that(res$Type[35], equals(-1))
  
  # TEST 10 -------------------------------------------------------------------
  # 3 Back, 1 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=3, forward=1, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.1216))
  expect_that(round(res$Ratio[4], 4), equals(0.0142))
  expect_that(round(res$Ratio[5], 4), equals(0.0768))
  expect_that(round(res$Ratio[6], 4), equals(0.0961))
  expect_that(round(res$Ratio[7], 4), equals(0.0782))
  expect_that(round(res$Ratio[8], 4), equals(0.0086))
  expect_that(round(res$Ratio[9], 4), equals(0.032))
  expect_that(round(res$Ratio[10], 4), equals(0.0136))
  expect_that(round(res$Ratio[11], 4), equals(0.0093))
  expect_that(round(res$Ratio[12], 4), equals(0.1195))
  expect_that(round(res$Ratio[13], 4), equals(0.0624))
  expect_that(round(res$Ratio[14], 4), equals(0.0506))
  expect_that(round(res$Ratio[15], 4), equals(0.0053))
  expect_that(round(res$Ratio[16], 4), equals(0.0592))
  expect_that(round(res$Ratio[17], 4), equals(0.0091))
  expect_that(round(res$Ratio[18], 4), equals(0.0097))
  expect_that(round(res$Ratio[19], 4), equals(0.0078))
  expect_that(round(res$Ratio[20], 4), equals(0.0893))
  expect_that(round(res$Ratio[21], 4), equals(0.0078))
  expect_that(round(res$Ratio[22], 4), equals(0.0655))
  expect_that(round(res$Ratio[23], 4), equals(0.0116))
  expect_that(round(res$Ratio[24], 4), equals(0.0062))
  expect_that(round(res$Ratio[25], 4), equals(0.1052))
  expect_that(round(res$Ratio[26], 4), equals(0.015))
  expect_that(round(res$Ratio[27], 4), equals(0.1832))
  expect_that(round(res$Ratio[28], 4), equals(0.0044))
  expect_that(round(res$Ratio[29], 4), equals(0.0054))
  expect_that(round(res$Ratio[30], 4), equals(0.006))
  expect_that(round(res$Ratio[31], 4), equals(0.0801))
  expect_that(round(res$Ratio[32], 4), equals(0.0493))
  expect_that(round(res$Ratio[33], 4), equals(0.0046))
  expect_that(round(res$Ratio[34], 4), equals(0.0099))
  expect_that(round(res$Ratio[35], 4), equals(0.1376))
  expect_that(round(res$Ratio[36], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-1))
  expect_that(res$Type[4], equals(1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(1))
  expect_that(res$Type[11], equals(-2))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(-1))
  expect_that(res$Type[15], equals(1))
  expect_that(res$Type[16], equals(-1))
  expect_that(res$Type[17], equals(-0.8))
  expect_that(res$Type[18], equals(-2))
  expect_that(res$Type[19], equals(-1.8))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(1))
  expect_that(res$Type[22], equals(-1))
  expect_that(res$Type[23], equals(1))
  expect_that(res$Type[24], equals(-2))
  expect_that(res$Type[25], equals(-1))
  expect_that(res$Type[26], equals(-2))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(-0.8))
  expect_that(res$Type[29], equals(-2))
  expect_that(res$Type[30], equals(-1.8))
  expect_that(res$Type[31], equals(-1))
  expect_that(res$Type[32], equals(-0.8))
  expect_that(res$Type[33], equals(1))
  expect_that(res$Type[34], equals(-2))
  expect_that(res$Type[35], equals(-1))
  expect_that(res$Type[36], equals(1))
  
  # TEST 11 -------------------------------------------------------------------
  # 3 Back, 2 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=3, forward=2, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0142))
  expect_that(round(res$Ratio[4], 4), equals(0.0768))
  expect_that(round(res$Ratio[5], 4), equals(0.0961))
  expect_that(round(res$Ratio[6], 4), equals(0.0086))
  expect_that(round(res$Ratio[7], 4), equals(0.032))
  expect_that(round(res$Ratio[8], 4), equals(0.0136))
  expect_that(round(res$Ratio[9], 4), equals(0.0093))
  expect_that(round(res$Ratio[10], 4), equals(0.1195))
  expect_that(round(res$Ratio[11], 4), equals(0.0624))
  expect_that(round(res$Ratio[12], 4), equals(0.0053))
  expect_that(round(res$Ratio[13], 4), equals(0.0592))
  expect_that(round(res$Ratio[14], 4), equals(0.0091))
  expect_that(round(res$Ratio[15], 4), equals(0.0078))
  expect_that(round(res$Ratio[16], 4), equals(0.0893))
  expect_that(round(res$Ratio[17], 4), equals(0.0078))
  expect_that(round(res$Ratio[18], 4), equals(0.0116))
  expect_that(round(res$Ratio[19], 4), equals(0.0062))
  expect_that(round(res$Ratio[20], 4), equals(0.1052))
  expect_that(round(res$Ratio[21], 4), equals(0.1832))
  expect_that(round(res$Ratio[22], 4), equals(0.0054))
  expect_that(round(res$Ratio[23], 4), equals(0.006))
  expect_that(round(res$Ratio[24], 4), equals(0.0801))
  expect_that(round(res$Ratio[25], 4), equals(0.0493))
  expect_that(round(res$Ratio[26], 4), equals(0.0046))
  expect_that(round(res$Ratio[27], 4), equals(0.0099))
  expect_that(round(res$Ratio[28], 4), equals(0.1376))
  expect_that(round(res$Ratio[29], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(1))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(1))
  expect_that(res$Type[9], equals(-2))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(1))
  expect_that(res$Type[13], equals(-1))
  expect_that(res$Type[14], equals(-0.8))
  expect_that(res$Type[15], equals(-1.8))
  expect_that(res$Type[16], equals(-1))
  expect_that(res$Type[17], equals(1))
  expect_that(res$Type[18], equals(1))
  expect_that(res$Type[19], equals(-2))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(-1))
  expect_that(res$Type[22], equals(-2))
  expect_that(res$Type[23], equals(-1.8))
  expect_that(res$Type[24], equals(-1))
  expect_that(res$Type[25], equals(-0.8))
  expect_that(res$Type[26], equals(1))
  expect_that(res$Type[27], equals(-2))
  expect_that(res$Type[28], equals(-1))
  expect_that(res$Type[29], equals(1))
  
  
  # TEST 12 -------------------------------------------------------------------
  # 3 Back, 3 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=3, forward=3, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0768))
  expect_that(round(res$Ratio[4], 4), equals(0.0961))
  expect_that(round(res$Ratio[5], 4), equals(0.032))
  expect_that(round(res$Ratio[6], 4), equals(0.0136))
  expect_that(round(res$Ratio[7], 4), equals(0.1195))
  expect_that(round(res$Ratio[8], 4), equals(0.0624))
  expect_that(round(res$Ratio[9], 4), equals(0.0592))
  expect_that(round(res$Ratio[10], 4), equals(0.0091))
  expect_that(round(res$Ratio[11], 4), equals(0.0078))
  expect_that(round(res$Ratio[12], 4), equals(0.0062))
  expect_that(round(res$Ratio[13], 4), equals(0.1052))
  expect_that(round(res$Ratio[14], 4), equals(0.0054))
  expect_that(round(res$Ratio[15], 4), equals(0.006))
  expect_that(round(res$Ratio[16], 4), equals(0.0801))
  expect_that(round(res$Ratio[17], 4), equals(0.0493))
  expect_that(round(res$Ratio[18], 4), equals(0.0046))
  expect_that(round(res$Ratio[19], 4), equals(0.0099))
  expect_that(round(res$Ratio[20], 4), equals(0.1376))
  expect_that(round(res$Ratio[21], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-1))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(-0.8))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-2))
  expect_that(res$Type[13], equals(-1))
  expect_that(res$Type[14], equals(-2))
  expect_that(res$Type[15], equals(-1.8))
  expect_that(res$Type[16], equals(-1))
  expect_that(res$Type[17], equals(-0.8))
  expect_that(res$Type[18], equals(1))
  expect_that(res$Type[19], equals(-2))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(1))
  
  
  # TEST 13 -------------------------------------------------------------------
  # 0 Back, 1 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=0, forward=1, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0185))
  expect_that(round(res$Ratio[2], 4), equals(0.0142))
  expect_that(round(res$Ratio[3], 4), equals(0.009))
  expect_that(round(res$Ratio[4], 4), equals(0.0086))
  expect_that(round(res$Ratio[5], 4), equals(0.0136))
  expect_that(round(res$Ratio[6], 4), equals(0.0624))
  expect_that(round(res$Ratio[7], 4), equals(0.083))
  expect_that(round(res$Ratio[8], 4), equals(0.0064))
  expect_that(round(res$Ratio[9], 4), equals(0.0053))
  expect_that(round(res$Ratio[10], 4), equals(0.0053))
  expect_that(round(res$Ratio[11], 4), equals(0.0078))
  expect_that(round(res$Ratio[12], 4), equals(0.0057))
  expect_that(round(res$Ratio[13], 4), equals(0.0116))
  expect_that(round(res$Ratio[14], 4), equals(0.0038))
  expect_that(round(res$Ratio[15], 4), equals(0.0967))
  expect_that(round(res$Ratio[16], 4), equals(0.0046))
  expect_that(round(res$Ratio[17], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(1))
  expect_that(res$Type[2], equals(1))
  expect_that(res$Type[3], equals(1))
  expect_that(res$Type[4], equals(1))
  expect_that(res$Type[5], equals(1))
  expect_that(res$Type[6], equals(1))
  expect_that(res$Type[7], equals(1))
  expect_that(res$Type[8], equals(1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(1))
  expect_that(res$Type[15], equals(1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(1))
  
  
  # TEST 14 -------------------------------------------------------------------
  # 0 Back, 2 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=0, forward=2, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0185))
  expect_that(round(res$Ratio[2], 4), equals(0.0927))
  expect_that(round(res$Ratio[3], 4), equals(0.0142))
  expect_that(round(res$Ratio[4], 4), equals(0.009))
  expect_that(round(res$Ratio[5], 4), equals(0.0779))
  expect_that(round(res$Ratio[6], 4), equals(0.0086))
  expect_that(round(res$Ratio[7], 4), equals(0.0136))
  expect_that(round(res$Ratio[8], 4), equals(0.0624))
  expect_that(round(res$Ratio[9], 4), equals(0.083))
  expect_that(round(res$Ratio[10], 4), equals(0.0064))
  expect_that(round(res$Ratio[11], 4), equals(0.0486))
  expect_that(round(res$Ratio[12], 4), equals(0.0053))
  expect_that(round(res$Ratio[13], 4), equals(0.0053))
  expect_that(round(res$Ratio[14], 4), equals(0.0095))
  expect_that(round(res$Ratio[15], 4), equals(0.0078))
  expect_that(round(res$Ratio[16], 4), equals(0.0057))
  expect_that(round(res$Ratio[17], 4), equals(0.0655))
  expect_that(round(res$Ratio[18], 4), equals(0.0116))
  expect_that(round(res$Ratio[19], 4), equals(0.0038))
  expect_that(round(res$Ratio[20], 4), equals(0.011))
  expect_that(round(res$Ratio[21], 4), equals(0.0967))
  expect_that(round(res$Ratio[22], 4), equals(0.0053))
  expect_that(round(res$Ratio[23], 4), equals(0.0046))
  expect_that(round(res$Ratio[24], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(1))
  expect_that(res$Type[2], equals(2))
  expect_that(res$Type[3], equals(1))
  expect_that(res$Type[4], equals(1))
  expect_that(res$Type[5], equals(2))
  expect_that(res$Type[6], equals(1))
  expect_that(res$Type[7], equals(1))
  expect_that(res$Type[8], equals(1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(1))
  expect_that(res$Type[11], equals(2))
  expect_that(res$Type[12], equals(1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(2))
  expect_that(res$Type[15], equals(1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(1.7))
  expect_that(res$Type[18], equals(1))
  expect_that(res$Type[19], equals(1))
  expect_that(res$Type[20], equals(2))
  expect_that(res$Type[21], equals(1))
  expect_that(res$Type[22], equals(1.2))
  expect_that(res$Type[23], equals(1))
  expect_that(res$Type[24], equals(1))
  
  
  # TEST 15 -------------------------------------------------------------------
  # 0 Back, 3 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=0, forward=3, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0185))
  expect_that(round(res$Ratio[2], 4), equals(0.0927))
  expect_that(round(res$Ratio[3], 4), equals(0.009))
  expect_that(round(res$Ratio[4], 4), equals(0.0779))
  expect_that(round(res$Ratio[5], 4), equals(0.0136))
  expect_that(round(res$Ratio[6], 4), equals(0.0082))
  expect_that(round(res$Ratio[7], 4), equals(0.0624))
  expect_that(round(res$Ratio[8], 4), equals(0.083))
  expect_that(round(res$Ratio[9], 4), equals(0.0064))
  expect_that(round(res$Ratio[10], 4), equals(0.0486))
  expect_that(round(res$Ratio[11], 4), equals(0.0053))
  expect_that(round(res$Ratio[12], 4), equals(0.0095))
  expect_that(round(res$Ratio[13], 4), equals(0.0076))
  expect_that(round(res$Ratio[14], 4), equals(0.0871))
  expect_that(round(res$Ratio[15], 4), equals(0.0078))
  expect_that(round(res$Ratio[16], 4), equals(0.0057))
  expect_that(round(res$Ratio[17], 4), equals(0.0655))
  expect_that(round(res$Ratio[18], 4), equals(0.0038))
  expect_that(round(res$Ratio[19], 4), equals(0.011))
  expect_that(round(res$Ratio[20], 4), equals(0.1344))
  expect_that(round(res$Ratio[21], 4), equals(0.0967))
  expect_that(round(res$Ratio[22], 4), equals(0.0053))
  expect_that(round(res$Ratio[23], 4), equals(0.0046))
  expect_that(round(res$Ratio[24], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(1))
  expect_that(res$Type[2], equals(2))
  expect_that(res$Type[3], equals(1))
  expect_that(res$Type[4], equals(2))
  expect_that(res$Type[5], equals(1))
  expect_that(res$Type[6], equals(3))
  expect_that(res$Type[7], equals(1))
  expect_that(res$Type[8], equals(1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(2))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(2))
  expect_that(res$Type[13], equals(2.2))
  expect_that(res$Type[14], equals(3))
  expect_that(res$Type[15], equals(1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(1.7))
  expect_that(res$Type[18], equals(1))
  expect_that(res$Type[19], equals(2))
  expect_that(res$Type[20], equals(3))
  expect_that(res$Type[21], equals(1))
  expect_that(res$Type[22], equals(1.2))
  expect_that(res$Type[23], equals(1))
  expect_that(res$Type[24], equals(1))
  
  
  # TEST 16 -------------------------------------------------------------------
  # 2 Back, 1 Forward, stutter interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=2, forward=1, interference=1,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0074))
  expect_that(round(res$Ratio[2], 4), equals(0.0742))
  expect_that(round(res$Ratio[3], 4), equals(0.0067))
  expect_that(round(res$Ratio[4], 4), equals(0.0035))
  expect_that(round(res$Ratio[5], 4), equals(0.0264))
  expect_that(round(res$Ratio[6], 4), equals(0.0637))
  expect_that(round(res$Ratio[7], 4), equals(0.0076))
  expect_that(round(res$Ratio[8], 4), equals(0.0697))
  expect_that(round(res$Ratio[9], 4), equals(0.0136))
  expect_that(round(res$Ratio[10], 4), equals(0.0064))
  expect_that(round(res$Ratio[11], 4), equals(0.0895))
  expect_that(round(res$Ratio[12], 4), equals(0.0062))
  expect_that(round(res$Ratio[13], 4), equals(0.0889))
  expect_that(round(res$Ratio[14], 4), equals(0.0185))
  expect_that(round(res$Ratio[15], 4), equals(0.0243))
  expect_that(round(res$Ratio[16], 4), equals(0.1216))
  expect_that(round(res$Ratio[17], 4), equals(0.0142))
  expect_that(round(res$Ratio[18], 4), equals(0.0768))
  expect_that(round(res$Ratio[19], 4), equals(0.0961))
  expect_that(round(res$Ratio[20], 4), equals(0.0417))
  expect_that(round(res$Ratio[21], 4), equals(0.009))
  expect_that(round(res$Ratio[22], 4), equals(0.009))
  expect_that(round(res$Ratio[23], 4), equals(0.0782))
  expect_that(round(res$Ratio[24], 4), equals(0.0086))
  expect_that(round(res$Ratio[25], 4), equals(0.032))
  expect_that(round(res$Ratio[26], 4), equals(0.0136))
  expect_that(round(res$Ratio[27], 4), equals(0.0093))
  expect_that(round(res$Ratio[28], 4), equals(0.1195))
  expect_that(round(res$Ratio[29], 4), equals(0.0624))
  expect_that(round(res$Ratio[30], 4), equals(0.0076))
  expect_that(round(res$Ratio[31], 4), equals(0.0109))
  expect_that(round(res$Ratio[32], 4), equals(0.0806))
  expect_that(round(res$Ratio[33], 4), equals(0.083))
  expect_that(round(res$Ratio[34], 4), equals(0.0921))
  expect_that(round(res$Ratio[35], 4), equals(0.0522))
  expect_that(round(res$Ratio[36], 4), equals(0.0064))
  expect_that(round(res$Ratio[37], 4), equals(0.0067))
  expect_that(round(res$Ratio[38], 4), equals(0.0506))
  expect_that(round(res$Ratio[39], 4), equals(0.0053))
  expect_that(round(res$Ratio[40], 4), equals(0.0592))
  expect_that(round(res$Ratio[41], 4), equals(0.0091))
  expect_that(round(res$Ratio[42], 4), equals(0.0053))
  expect_that(round(res$Ratio[43], 4), equals(0.0097))
  expect_that(round(res$Ratio[44], 4), equals(0.0078))
  expect_that(round(res$Ratio[45], 4), equals(0.0893))
  expect_that(round(res$Ratio[46], 4), equals(0.0078))
  expect_that(round(res$Ratio[47], 4), equals(0.0057))
  expect_that(round(res$Ratio[48], 4), equals(0.0057))
  expect_that(round(res$Ratio[49], 4), equals(0.0655))
  expect_that(round(res$Ratio[50], 4), equals(0.0116))
  expect_that(round(res$Ratio[51], 4), equals(0.0062))
  expect_that(round(res$Ratio[52], 4), equals(0.1052))
  expect_that(round(res$Ratio[53], 4), equals(0.0038))
  expect_that(round(res$Ratio[54], 4), equals(0.015))
  expect_that(round(res$Ratio[55], 4), equals(0.1832))
  expect_that(round(res$Ratio[56], 4), equals(0.0525))
  expect_that(round(res$Ratio[57], 4), equals(0.0967))
  expect_that(round(res$Ratio[58], 4), equals(0.0804))
  expect_that(round(res$Ratio[59], 4), equals(0.0044))
  expect_that(round(res$Ratio[60], 4), equals(0.0054))
  expect_that(round(res$Ratio[61], 4), equals(0.006))
  expect_that(round(res$Ratio[62], 4), equals(0.0801))
  expect_that(round(res$Ratio[63], 4), equals(0.0493))
  expect_that(round(res$Ratio[64], 4), equals(0.0046))
  expect_that(round(res$Ratio[65], 4), equals(0.0099))
  expect_that(round(res$Ratio[66], 4), equals(0.1376))
  expect_that(round(res$Ratio[67], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(1))
  expect_that(res$Type[4], equals(-2))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(-2))
  expect_that(res$Type[11], equals(-1))
  expect_that(res$Type[12], equals(-2))
  expect_that(res$Type[13], equals(-1))
  expect_that(res$Type[14], equals(1))
  expect_that(res$Type[15], equals(-2))
  expect_that(res$Type[16], equals(-1))
  expect_that(res$Type[17], equals(1))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(-1))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(1))
  expect_that(res$Type[22], equals(-2))
  expect_that(res$Type[23], equals(-1))
  expect_that(res$Type[24], equals(1))
  expect_that(res$Type[25], equals(-1))
  expect_that(res$Type[26], equals(1))
  expect_that(res$Type[27], equals(-2))
  expect_that(res$Type[28], equals(-1))
  expect_that(res$Type[29], equals(1))
  expect_that(res$Type[30], equals(-2))
  expect_that(res$Type[31], equals(-1.8))
  expect_that(res$Type[32], equals(-1))
  expect_that(res$Type[33], equals(1))
  expect_that(res$Type[34], equals(-1))
  expect_that(res$Type[35], equals(-1))
  expect_that(res$Type[36], equals(1))
  expect_that(res$Type[37], equals(-2))
  expect_that(res$Type[38], equals(-1))
  expect_that(res$Type[39], equals(1))
  expect_that(res$Type[40], equals(-1))
  expect_that(res$Type[41], equals(-0.8))
  expect_that(res$Type[42], equals(1))
  expect_that(res$Type[43], equals(-2))
  expect_that(res$Type[44], equals(-1.8))
  expect_that(res$Type[45], equals(-1))
  expect_that(res$Type[46], equals(1))
  expect_that(res$Type[47], equals(1))
  expect_that(res$Type[48], equals(-1.7))
  expect_that(res$Type[49], equals(-1))
  expect_that(res$Type[50], equals(1))
  expect_that(res$Type[51], equals(-2))
  expect_that(res$Type[52], equals(-1))
  expect_that(res$Type[53], equals(1))
  expect_that(res$Type[54], equals(-2))
  expect_that(res$Type[55], equals(-1))
  expect_that(res$Type[56], equals(-1))
  expect_that(res$Type[57], equals(1))
  expect_that(res$Type[58], equals(-1))
  expect_that(res$Type[59], equals(-0.8))
  expect_that(res$Type[60], equals(-2))
  expect_that(res$Type[61], equals(-1.8))
  expect_that(res$Type[62], equals(-1))
  expect_that(res$Type[63], equals(-0.8))
  expect_that(res$Type[64], equals(1))
  expect_that(res$Type[65], equals(-2))
  expect_that(res$Type[66], equals(-1))
  expect_that(res$Type[67], equals(1))
  
  
  # TEST 17 -------------------------------------------------------------------
  # 2 Back, 1 Forward, allele interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=2, forward=1, interference=2,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0074))
  expect_that(round(res$Ratio[2], 4), equals(0.0742))
  expect_that(round(res$Ratio[3], 4), equals(0.0882))
  expect_that(round(res$Ratio[4], 4), equals(0.0067))
  expect_that(round(res$Ratio[5], 4), equals(0.0035))
  expect_that(round(res$Ratio[6], 4), equals(0.0264))
  expect_that(round(res$Ratio[7], 4), equals(0.0637))
  expect_that(round(res$Ratio[8], 4), equals(0.0725))
  expect_that(round(res$Ratio[9], 4), equals(0.0076))
  expect_that(round(res$Ratio[10], 4), equals(0.0697))
  expect_that(round(res$Ratio[11], 4), equals(0.0809))
  expect_that(round(res$Ratio[12], 4), equals(0.0136))
  expect_that(round(res$Ratio[13], 4), equals(0.0064))
  expect_that(round(res$Ratio[14], 4), equals(0.0895))
  expect_that(round(res$Ratio[15], 4), equals(0.099))
  expect_that(round(res$Ratio[16], 4), equals(0.0062))
  expect_that(round(res$Ratio[17], 4), equals(0.0889))
  expect_that(round(res$Ratio[18], 4), equals(0.0185))
  expect_that(round(res$Ratio[19], 4), equals(0.0243))
  expect_that(round(res$Ratio[20], 4), equals(0.1216))
  expect_that(round(res$Ratio[21], 4), equals(0.0142))
  expect_that(round(res$Ratio[22], 4), equals(0.0768))
  expect_that(round(res$Ratio[23], 4), equals(0.0961))
  expect_that(round(res$Ratio[24], 4), equals(0.0417))
  expect_that(round(res$Ratio[25], 4), equals(0.009))
  expect_that(round(res$Ratio[26], 4), equals(0.009))
  expect_that(round(res$Ratio[27], 4), equals(0.0782))
  expect_that(round(res$Ratio[28], 4), equals(0.0086))
  expect_that(round(res$Ratio[29], 4), equals(0.032))
  expect_that(round(res$Ratio[30], 4), equals(0.0136))
  expect_that(round(res$Ratio[31], 4), equals(0.0093))
  expect_that(round(res$Ratio[32], 4), equals(0.1195))
  expect_that(round(res$Ratio[33], 4), equals(0.0624))
  expect_that(round(res$Ratio[34], 4), equals(0.0076))
  expect_that(round(res$Ratio[35], 4), equals(0.0109))
  expect_that(round(res$Ratio[36], 4), equals(0.0806))
  expect_that(round(res$Ratio[37], 4), equals(0.083))
  expect_that(round(res$Ratio[38], 4), equals(0.0921))
  expect_that(round(res$Ratio[39], 4), equals(0.0522))
  expect_that(round(res$Ratio[40], 4), equals(0.0064))
  expect_that(round(res$Ratio[41], 4), equals(0.0067))
  expect_that(round(res$Ratio[42], 4), equals(0.0506))
  expect_that(round(res$Ratio[43], 4), equals(0.0053))
  expect_that(round(res$Ratio[44], 4), equals(0.0592))
  expect_that(round(res$Ratio[45], 4), equals(0.0091))
  expect_that(round(res$Ratio[46], 4), equals(0.0053))
  expect_that(round(res$Ratio[47], 4), equals(0.0097))
  expect_that(round(res$Ratio[48], 4), equals(0.0078))
  expect_that(round(res$Ratio[49], 4), equals(0.0893))
  expect_that(round(res$Ratio[50], 4), equals(0.0078))
  expect_that(round(res$Ratio[51], 4), equals(0.0057))
  expect_that(round(res$Ratio[52], 4), equals(0.0057))
  expect_that(round(res$Ratio[53], 4), equals(0.0655))
  expect_that(round(res$Ratio[54], 4), equals(0.0116))
  expect_that(round(res$Ratio[55], 4), equals(0.0062))
  expect_that(round(res$Ratio[56], 4), equals(0.1052))
  expect_that(round(res$Ratio[57], 4), equals(0.0038))
  expect_that(round(res$Ratio[58], 4), equals(0.015))
  expect_that(round(res$Ratio[59], 4), equals(0.1832))
  expect_that(round(res$Ratio[60], 4), equals(0.0525))
  expect_that(round(res$Ratio[61], 4), equals(0.0967))
  expect_that(round(res$Ratio[62], 4), equals(0.0804))
  expect_that(round(res$Ratio[63], 4), equals(0.0044))
  expect_that(round(res$Ratio[64], 4), equals(0.0054))
  expect_that(round(res$Ratio[65], 4), equals(0.006))
  expect_that(round(res$Ratio[66], 4), equals(0.0801))
  expect_that(round(res$Ratio[67], 4), equals(0.0493))
  expect_that(round(res$Ratio[68], 4), equals(0.0046))
  expect_that(round(res$Ratio[69], 4), equals(0.0099))
  expect_that(round(res$Ratio[70], 4), equals(0.1376))
  expect_that(round(res$Ratio[71], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(1))
  expect_that(res$Type[5], equals(-2))
  expect_that(res$Type[6], equals(-1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-2))
  expect_that(res$Type[9], equals(1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(-2))
  expect_that(res$Type[12], equals(1))
  expect_that(res$Type[13], equals(-2))
  expect_that(res$Type[14], equals(-1))
  expect_that(res$Type[15], equals(-2))
  expect_that(res$Type[16], equals(-2))
  expect_that(res$Type[17], equals(-1))
  expect_that(res$Type[18], equals(1))
  expect_that(res$Type[19], equals(-2))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(1))
  expect_that(res$Type[22], equals(-1))
  expect_that(res$Type[23], equals(-1))
  expect_that(res$Type[24], equals(-1))
  expect_that(res$Type[25], equals(1))
  expect_that(res$Type[26], equals(-2))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(1))
  expect_that(res$Type[29], equals(-1))
  expect_that(res$Type[30], equals(1))
  expect_that(res$Type[31], equals(-2))
  expect_that(res$Type[32], equals(-1))
  expect_that(res$Type[33], equals(1))
  expect_that(res$Type[34], equals(-2))
  expect_that(res$Type[35], equals(-1.8))
  expect_that(res$Type[36], equals(-1))
  expect_that(res$Type[37], equals(1))
  expect_that(res$Type[38], equals(-1))
  expect_that(res$Type[39], equals(-1))
  expect_that(res$Type[40], equals(1))
  expect_that(res$Type[41], equals(-2))
  expect_that(res$Type[42], equals(-1))
  expect_that(res$Type[43], equals(1))
  expect_that(res$Type[44], equals(-1))
  expect_that(res$Type[45], equals(-0.8))
  expect_that(res$Type[46], equals(1))
  expect_that(res$Type[47], equals(-2))
  expect_that(res$Type[48], equals(-1.8))
  expect_that(res$Type[49], equals(-1))
  expect_that(res$Type[50], equals(1))
  expect_that(res$Type[51], equals(1))
  expect_that(res$Type[52], equals(-1.7))
  expect_that(res$Type[53], equals(-1))
  expect_that(res$Type[54], equals(1))
  expect_that(res$Type[55], equals(-2))
  expect_that(res$Type[56], equals(-1))
  expect_that(res$Type[57], equals(1))
  expect_that(res$Type[58], equals(-2))
  expect_that(res$Type[59], equals(-1))
  expect_that(res$Type[60], equals(-1))
  expect_that(res$Type[61], equals(1))
  expect_that(res$Type[62], equals(-1))
  expect_that(res$Type[63], equals(-0.8))
  expect_that(res$Type[64], equals(-2))
  expect_that(res$Type[65], equals(-1.8))
  expect_that(res$Type[66], equals(-1))
  expect_that(res$Type[67], equals(-0.8))
  expect_that(res$Type[68], equals(1))
  expect_that(res$Type[69], equals(-2))
  expect_that(res$Type[70], equals(-1))
  expect_that(res$Type[71], equals(1))

  
  # TEST 18 -------------------------------------------------------------------
  # Test replacment of 'false' stutters.
  # 2 Back, 1 Forward, No interference.
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=ref4,
                          back=2, forward=1, interference=0,
                          replaceVal=c(-1.8, -0.8), byVal=c(-1.2, -0.2), debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0062))
  expect_that(round(res$Ratio[4], 4), equals(0.0889))
  expect_that(round(res$Ratio[5], 4), equals(0.1216))
  expect_that(round(res$Ratio[6], 4), equals(0.0142))
  expect_that(round(res$Ratio[7], 4), equals(0.0768))
  expect_that(round(res$Ratio[8], 4), equals(0.0961))
  expect_that(round(res$Ratio[9], 4), equals(0.0417))
  expect_that(round(res$Ratio[10], 4), equals(0.0782))
  expect_that(round(res$Ratio[11], 4), equals(0.0086))
  expect_that(round(res$Ratio[12], 4), equals(0.032))
  expect_that(round(res$Ratio[13], 4), equals(0.0136))
  expect_that(round(res$Ratio[14], 4), equals(0.0093))
  expect_that(round(res$Ratio[15], 4), equals(0.1195))
  expect_that(round(res$Ratio[16], 4), equals(0.0624))
  expect_that(round(res$Ratio[17], 4), equals(0.0522))
  expect_that(round(res$Ratio[18], 4), equals(0.0506))
  expect_that(round(res$Ratio[19], 4), equals(0.0053))
  expect_that(round(res$Ratio[20], 4), equals(0.0592))
  expect_that(round(res$Ratio[21], 4), equals(0.0091))
  expect_that(round(res$Ratio[22], 4), equals(0.0053))
  expect_that(round(res$Ratio[23], 4), equals(0.0097))
  expect_that(round(res$Ratio[24], 4), equals(0.0078))
  expect_that(round(res$Ratio[25], 4), equals(0.0893))
  expect_that(round(res$Ratio[26], 4), equals(0.0078))
  expect_that(round(res$Ratio[27], 4), equals(0.0655))
  expect_that(round(res$Ratio[28], 4), equals(0.0116))
  expect_that(round(res$Ratio[29], 4), equals(0.0062))
  expect_that(round(res$Ratio[30], 4), equals(0.1052))
  expect_that(round(res$Ratio[31], 4), equals(0.0038))
  expect_that(round(res$Ratio[32], 4), equals(0.015))
  expect_that(round(res$Ratio[33], 4), equals(0.1832))
  expect_that(round(res$Ratio[34], 4), equals(0.0044))
  expect_that(round(res$Ratio[35], 4), equals(0.0054))
  expect_that(round(res$Ratio[36], 4), equals(0.006))
  expect_that(round(res$Ratio[37], 4), equals(0.0801))
  expect_that(round(res$Ratio[38], 4), equals(0.0493))
  expect_that(round(res$Ratio[39], 4), equals(0.0046))
  expect_that(round(res$Ratio[40], 4), equals(0.0099))
  expect_that(round(res$Ratio[41], 4), equals(0.1376))
  expect_that(round(res$Ratio[42], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(-2))
  expect_that(res$Type[15], equals(-1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(-1))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(1))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(-0.2))
  expect_that(res$Type[22], equals(1))
  expect_that(res$Type[23], equals(-2))
  expect_that(res$Type[24], equals(-1.2))
  expect_that(res$Type[25], equals(-1))
  expect_that(res$Type[26], equals(1))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(1))
  expect_that(res$Type[29], equals(-2))
  expect_that(res$Type[30], equals(-1))
  expect_that(res$Type[31], equals(1))
  expect_that(res$Type[32], equals(-2))
  expect_that(res$Type[33], equals(-1))
  expect_that(res$Type[34], equals(-0.2))
  expect_that(res$Type[35], equals(-2))
  expect_that(res$Type[36], equals(-1.2))
  expect_that(res$Type[37], equals(-1))
  expect_that(res$Type[38], equals(-0.2))
  expect_that(res$Type[39], equals(1))
  expect_that(res$Type[40], equals(-2))
  expect_that(res$Type[41], equals(-1))
  expect_that(res$Type[42], equals(1))
  

  # TEST 19 -------------------------------------------------------------------
  # Test single entries for homozygotes.
  # 2 Back, 1 Forward, No interference.
  
  refSingle <- ref4[!rownames(ref4) %in% c(2,6), ]
  
  # Analyse dataframe.
  res <- calculateStutter(data=setA1, ref=refSingle,
                          back=2, forward=1, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0062))
  expect_that(round(res$Ratio[4], 4), equals(0.0889))
  expect_that(round(res$Ratio[5], 4), equals(0.1216))
  expect_that(round(res$Ratio[6], 4), equals(0.0142))
  expect_that(round(res$Ratio[7], 4), equals(0.0768))
  expect_that(round(res$Ratio[8], 4), equals(0.0961))
  expect_that(round(res$Ratio[9], 4), equals(0.0417))
  expect_that(round(res$Ratio[10], 4), equals(0.0782))
  expect_that(round(res$Ratio[11], 4), equals(0.0086))
  expect_that(round(res$Ratio[12], 4), equals(0.032))
  expect_that(round(res$Ratio[13], 4), equals(0.0136))
  expect_that(round(res$Ratio[14], 4), equals(0.0093))
  expect_that(round(res$Ratio[15], 4), equals(0.1195))
  expect_that(round(res$Ratio[16], 4), equals(0.0624))
  expect_that(round(res$Ratio[17], 4), equals(0.0522))
  expect_that(round(res$Ratio[18], 4), equals(0.0506))
  expect_that(round(res$Ratio[19], 4), equals(0.0053))
  expect_that(round(res$Ratio[20], 4), equals(0.0592))
  expect_that(round(res$Ratio[21], 4), equals(0.0091))
  expect_that(round(res$Ratio[22], 4), equals(0.0053))
  expect_that(round(res$Ratio[23], 4), equals(0.0097))
  expect_that(round(res$Ratio[24], 4), equals(0.0078))
  expect_that(round(res$Ratio[25], 4), equals(0.0893))
  expect_that(round(res$Ratio[26], 4), equals(0.0078))
  expect_that(round(res$Ratio[27], 4), equals(0.0655))
  expect_that(round(res$Ratio[28], 4), equals(0.0116))
  expect_that(round(res$Ratio[29], 4), equals(0.0062))
  expect_that(round(res$Ratio[30], 4), equals(0.1052))
  expect_that(round(res$Ratio[31], 4), equals(0.0038))
  expect_that(round(res$Ratio[32], 4), equals(0.015))
  expect_that(round(res$Ratio[33], 4), equals(0.1832))
  expect_that(round(res$Ratio[34], 4), equals(0.0044))
  expect_that(round(res$Ratio[35], 4), equals(0.0054))
  expect_that(round(res$Ratio[36], 4), equals(0.006))
  expect_that(round(res$Ratio[37], 4), equals(0.0801))
  expect_that(round(res$Ratio[38], 4), equals(0.0493))
  expect_that(round(res$Ratio[39], 4), equals(0.0046))
  expect_that(round(res$Ratio[40], 4), equals(0.0099))
  expect_that(round(res$Ratio[41], 4), equals(0.1376))
  expect_that(round(res$Ratio[42], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(-2))
  expect_that(res$Type[15], equals(-1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(-1))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(1))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(-0.8))
  expect_that(res$Type[22], equals(1))
  expect_that(res$Type[23], equals(-2))
  expect_that(res$Type[24], equals(-1.8))
  expect_that(res$Type[25], equals(-1))
  expect_that(res$Type[26], equals(1))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(1))
  expect_that(res$Type[29], equals(-2))
  expect_that(res$Type[30], equals(-1))
  expect_that(res$Type[31], equals(1))
  expect_that(res$Type[32], equals(-2))
  expect_that(res$Type[33], equals(-1))
  expect_that(res$Type[34], equals(-0.8))
  expect_that(res$Type[35], equals(-2))
  expect_that(res$Type[36], equals(-1.8))
  expect_that(res$Type[37], equals(-1))
  expect_that(res$Type[38], equals(-0.8))
  expect_that(res$Type[39], equals(1))
  expect_that(res$Type[40], equals(-2))
  expect_that(res$Type[41], equals(-1))
  expect_that(res$Type[42], equals(1))
  
  
  # TEST 20 -------------------------------------------------------------------
  # Test single entries for homozygotes.
  # 2 Back, 1 Forward, No interference.
  
  set4Missing <- set4[set4$Sample.Name != "07-A2.5", ]
  
  # Analyse dataframe.
  res <- calculateStutter(data=set4Missing, ref=ref4,
                          back=2, forward=1, interference=0,
                          replaceVal=NULL, byVal=NULL, debug=FALSE)
  
  # write.table(x=res,"clipboard",sep="\t",row.names=FALSE,col.names=TRUE)
  
  
  # Check return class.  
  expect_that(class(res), matches(class(data.frame())))
  
  # Check that expected columns exist.  
  expect_false(is.null(res$Marker))
  expect_false(is.null(res$Allele))
  expect_false(is.null(res$HeightA))
  expect_false(is.null(res$Stutter))
  expect_false(is.null(res$HeightS))
  expect_false(is.null(res$Ratio))
  expect_false(is.null(res$Type))
  
  # Check result: Ratio.
  expect_that(round(res$Ratio[1], 4), equals(0.0035))
  expect_that(round(res$Ratio[2], 4), equals(0.0264))
  expect_that(round(res$Ratio[3], 4), equals(0.0062))
  expect_that(round(res$Ratio[4], 4), equals(0.0889))
  expect_that(round(res$Ratio[5], 4), equals(0.1216))
  expect_that(round(res$Ratio[6], 4), equals(0.0142))
  expect_that(round(res$Ratio[7], 4), equals(0.0768))
  expect_that(round(res$Ratio[8], 4), equals(0.0961))
  expect_that(round(res$Ratio[9], 4), equals(0.0417))
  expect_that(round(res$Ratio[10], 4), equals(0.0782))
  expect_that(round(res$Ratio[11], 4), equals(0.0086))
  expect_that(round(res$Ratio[12], 4), equals(0.032))
  expect_that(round(res$Ratio[13], 4), equals(0.0136))
  expect_that(round(res$Ratio[14], 4), equals(0.0093))
  expect_that(round(res$Ratio[15], 4), equals(0.1195))
  expect_that(round(res$Ratio[16], 4), equals(0.0624))
  expect_that(round(res$Ratio[17], 4), equals(0.0522))
  expect_that(round(res$Ratio[18], 4), equals(0.0506))
  expect_that(round(res$Ratio[19], 4), equals(0.0053))
  expect_that(round(res$Ratio[20], 4), equals(0.0592))
  expect_that(round(res$Ratio[21], 4), equals(0.0091))
  expect_that(round(res$Ratio[22], 4), equals(0.0053))
  expect_that(round(res$Ratio[23], 4), equals(0.0097))
  expect_that(round(res$Ratio[24], 4), equals(0.0078))
  expect_that(round(res$Ratio[25], 4), equals(0.0893))
  expect_that(round(res$Ratio[26], 4), equals(0.0078))
  expect_that(round(res$Ratio[27], 4), equals(0.0655))
  expect_that(round(res$Ratio[28], 4), equals(0.0116))
  expect_that(round(res$Ratio[29], 4), equals(0.0062))
  expect_that(round(res$Ratio[30], 4), equals(0.1052))
  expect_that(round(res$Ratio[31], 4), equals(0.0038))
  expect_that(round(res$Ratio[32], 4), equals(0.015))
  expect_that(round(res$Ratio[33], 4), equals(0.1832))
  expect_that(round(res$Ratio[34], 4), equals(0.0044))
  expect_that(round(res$Ratio[35], 4), equals(0.0054))
  expect_that(round(res$Ratio[36], 4), equals(0.006))
  expect_that(round(res$Ratio[37], 4), equals(0.0801))
  expect_that(round(res$Ratio[38], 4), equals(0.0493))
  expect_that(round(res$Ratio[39], 4), equals(0.0046))
  expect_that(round(res$Ratio[40], 4), equals(0.0099))
  expect_that(round(res$Ratio[41], 4), equals(0.1376))
  expect_that(round(res$Ratio[42], 4), equals(0.007))
  
  # Check result: Type.
  expect_that(res$Type[1], equals(-2))
  expect_that(res$Type[2], equals(-1))
  expect_that(res$Type[3], equals(-2))
  expect_that(res$Type[4], equals(-1))
  expect_that(res$Type[5], equals(-1))
  expect_that(res$Type[6], equals(1))
  expect_that(res$Type[7], equals(-1))
  expect_that(res$Type[8], equals(-1))
  expect_that(res$Type[9], equals(-1))
  expect_that(res$Type[10], equals(-1))
  expect_that(res$Type[11], equals(1))
  expect_that(res$Type[12], equals(-1))
  expect_that(res$Type[13], equals(1))
  expect_that(res$Type[14], equals(-2))
  expect_that(res$Type[15], equals(-1))
  expect_that(res$Type[16], equals(1))
  expect_that(res$Type[17], equals(-1))
  expect_that(res$Type[18], equals(-1))
  expect_that(res$Type[19], equals(1))
  expect_that(res$Type[20], equals(-1))
  expect_that(res$Type[21], equals(-0.8))
  expect_that(res$Type[22], equals(1))
  expect_that(res$Type[23], equals(-2))
  expect_that(res$Type[24], equals(-1.8))
  expect_that(res$Type[25], equals(-1))
  expect_that(res$Type[26], equals(1))
  expect_that(res$Type[27], equals(-1))
  expect_that(res$Type[28], equals(1))
  expect_that(res$Type[29], equals(-2))
  expect_that(res$Type[30], equals(-1))
  expect_that(res$Type[31], equals(1))
  expect_that(res$Type[32], equals(-2))
  expect_that(res$Type[33], equals(-1))
  expect_that(res$Type[34], equals(-0.8))
  expect_that(res$Type[35], equals(-2))
  expect_that(res$Type[36], equals(-1.8))
  expect_that(res$Type[37], equals(-1))
  expect_that(res$Type[38], equals(-0.8))
  expect_that(res$Type[39], equals(1))
  expect_that(res$Type[40], equals(-2))
  expect_that(res$Type[41], equals(-1))
  expect_that(res$Type[42], equals(1))
  
  
  
})