\name{addData}
\alias{addData}
\title{Adds new data columns to a data frame}
\usage{
addData(data, newData, byCol, thenByCol = NULL, exact = TRUE,
  ignoreCase = TRUE, debug = FALSE)
}
\arguments{
  \item{data}{Data frame containing your main data.}

  \item{newData}{Data frame containing information you want
  to add to 'data'.}

  \item{byCol}{character, key column.}

  \item{thenByCol}{character, key column level 2.}

  \item{exact}{logical, TRUE matches keys exact.}

  \item{ignoreCase}{logical, TRUE ignore case.}

  \item{debug}{logical indicating printing debug
  information.}
}
\value{
data.frame the original data frame containing additional
columns.
}
\description{
\code{addData} Adds columns in 'newData' to 'data' by
column 'byCol'.
}
\details{
Information in columns in data frame 'newData' is added to
data frame 'data' based on value in column 'byCol' and
optionally on 'thenByCol'.
}
\examples{
# Get marker names and alleles for Promega PowerPlex ESX 17.
x <- getKit("ESX17", what="Allele")
# Get marker names and colors for Promega PowerPlex ESX 17.
y <- getKit("ESX17", what="Color")
# Add color information to allele information.
z <- addData(data=x, newData=y, byCol="Marker")
print(x)
print(y)
print(z)
}
\keyword{internal}

