% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\docType{package}
\name{stringmagic-package}
\alias{stringmagic}
\alias{stringmagic-package}
\title{String operations and interpolation: magic edition}
\description{
The stringmagic package introduces a new language tailored to create complex character strings.
Use the function string_magic to interpolate a variable inside a character string and to apply,
on-the-fly, any arbitrary string operation.
}
\details{
It supports over 50 basic operations, seamless customization, nesting,
pluralization, and much more. Writing complex character strings has never been that easy!

To get an overview of the package: see the \href{https://lrberge.github.io/stringmagic/index.html}{Readme}.
To get started with string_magic,
see \href{https://lrberge.github.io/stringmagic/articles/guide_string_magic.html}{the vignette}.

This package also enhances regular string functions (like grep and co) with
specialized functions to:
\itemize{
\item detect combinations of regular expressions
\item chain basic string operations
\item clean character string vectors
}

See more in the \href{https://lrberge.github.io/stringmagic/articles/guide_string_tools.html}{dedicated vignette}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://lrberge.github.io/stringmagic/}
  \item \url{https://github.com/lrberge/stringmagic}
  \item Report bugs at \url{https://github.com/lrberge/stringmagic/issues}
}

}
\author{
Laurent Berge

For a few functions (e.g. string_split2df) I use internally an algorithm to turn vectors
into indexes (i.e. integer vectors of the same length ranging to 1 to the number of groups).
This algorithm was inspired by Sebastian Krantz's \href{https://cran.r-project.org/package=collapse}{collapse}
(if you don't know about it, you should definitely check it out!) who uses an algorithm
from Morgan Jacob's \href{https://cran.r-project.org/package=kit}{kit} package.
}
