% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_replace_na}
\alias{stri_replace_na}
\title{Replace Missing Values in a Character Vector}
\usage{
stri_replace_na(str, replacement = "NA")
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{replacement}{single string}
}
\value{
Returns a character vector.
}
\description{
This function offers a convenient way to replace each \code{NA}
in a character vector with a given string.
}
\details{
This function is roughly equivalent to
\code{str2 <- stri_enc_toutf8(str);
str2[is.na(str2)] <- stri_enc_toutf8(replacement);
str2}.
It may be used e.g. wherever ``plain \R'' \code{NA} handling is
desired, see Examples.
}
\examples{
\donttest{
x <- c('test', NA)
stri_paste(x, 1:2)                           # "test1" NA
paste(x, 1:2)                                # "test 1" "NA 2"
stri_paste(stri_replace_na(x), 1:2, sep=' ') # "test 1" "NA 2"
}
}
\seealso{
Other search_replace: \code{\link{stri_replace}},
  \code{\link{stri_replace_all}},
  \code{\link{stri_replace_all_charclass}},
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_all_fixed}},
  \code{\link{stri_replace_all_regex}},
  \code{\link{stri_replace_first}},
  \code{\link{stri_replace_first_charclass}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_first_regex}},
  \code{\link{stri_replace_last}},
  \code{\link{stri_replace_last_charclass}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_fixed}},
  \code{\link{stri_replace_last_regex}};
  \code{\link{stri_trim}}, \code{\link{stri_trim}},
  \code{\link{stri_trim_both}},
  \code{\link{stri_trim_left}},
  \code{\link{stri_trim_right}};
  \code{\link{stringi-search}}
}

